/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.net.InetAddresses;
import io.airlift.http.server.Inet4Network;
import io.airlift.testing.EquivalenceTester;
import java.net.Inet4Address;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestInet4Network {
    @Test
    public void testFromCidrValid() {
        TestInet4Network.assertCidrValid("0.0.0.0/0");
        TestInet4Network.assertCidrValid("1.2.3.4/32");
        TestInet4Network.assertCidrValid("8.0.0.0/8");
        TestInet4Network.assertCidrValid("8.8.8.0/24");
        TestInet4Network.assertCidrValid("8.8.8.8/32");
        TestInet4Network.assertCidrValid("255.255.255.255/32");
    }

    private static void assertCidrValid(String cidr) {
        Assert.assertEquals((String)Inet4Network.fromCidr((String)cidr).toString(), (String)cidr);
    }

    @DataProvider(name="invalidCidr")
    public Object[][] invalidCidrProvider() {
        return new Object[][]{{" 0.0.0.0/0"}, {"0.0.0.0/0 "}, {"x.0.0.0/0"}, {"0.x.0.0/0"}, {"0.0.x.0/0"}, {"0.0.0.x/0"}, {"0.0.0.0/x"}, {"256.0.0.0/0"}, {"0.0.0.256/0"}, {"0.0.0.0/33"}, {"8.8.8.1/24"}, {"1.0.0.0/0"}, {"8.0.0"}, {"8.0.0.0.0"}, {"-8.1.0.0"}, {"8.-1.0.0"}};
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, dataProvider="invalidCidr")
    public void testFromCidrInvalid(String cidr) {
        Inet4Network.fromCidr((String)cidr);
    }

    @Test
    public void testStartingAndEndingAddress() {
        TestInet4Network.assertStartingAndEndingAddress("0.0.0.0/0", "255.255.255.255");
        TestInet4Network.assertStartingAndEndingAddress("0.0.0.0/1", "127.255.255.255");
        TestInet4Network.assertStartingAndEndingAddress("0.0.0.0/8", "0.255.255.255");
        TestInet4Network.assertStartingAndEndingAddress("0.0.0.0/24", "0.0.0.255");
        TestInet4Network.assertStartingAndEndingAddress("0.0.0.0/32", "0.0.0.0");
        TestInet4Network.assertStartingAndEndingAddress("255.255.255.0/24", "255.255.255.255");
        TestInet4Network.assertStartingAndEndingAddress("8.8.8.8/32", "8.8.8.8");
        TestInet4Network.assertStartingAndEndingAddress("8.8.8.8/32", "8.8.8.8");
        TestInet4Network.assertStartingAndEndingAddress("202.12.128.0/18", "202.12.191.255");
    }

    private static void assertStartingAndEndingAddress(String cidr, String endingAddress) {
        String startingAddress = cidr.substring(0, cidr.indexOf(47));
        Inet4Network network = Inet4Network.fromCidr((String)cidr);
        Assert.assertEquals((Object)network.getStartingAddress(), (Object)InetAddresses.forString((String)startingAddress));
        Assert.assertEquals((Object)network.getEndingAddress(), (Object)InetAddresses.forString((String)endingAddress));
    }

    @Test
    public void testAddressToLong() {
        TestInet4Network.assertAddressToLong("0.0.0.0", 0L);
        TestInet4Network.assertAddressToLong("255.255.255.255", 0xFFFFFFFFL);
        TestInet4Network.assertAddressToLong("8.8.8.8", 0x8080808L);
        TestInet4Network.assertAddressToLong("202.12.128.0", 3389816832L);
        TestInet4Network.assertAddressToLong("202.12.128.254", 3389817086L);
    }

    private static void assertAddressToLong(String address, long ip) {
        Inet4Address addr = (Inet4Address)InetAddresses.forString((String)address);
        Assert.assertEquals((long)Inet4Network.addressToLong((Inet4Address)addr), (long)ip);
    }

    @Test
    public void testFromAddress() {
        TestInet4Network.assertFromAddress("1.2.3.4", "1.2.3.4/32", 32);
        TestInet4Network.assertFromAddress("8.8.8.8", "8.8.8.8/32", 32);
        TestInet4Network.assertFromAddress("208.86.202.10", "208.86.202.10/32", 32);
        TestInet4Network.assertFromAddress("208.86.202.0", "208.86.202.0/24", 24);
    }

    private static void assertFromAddress(String address, String cidr, int bits) {
        Inet4Address addr = (Inet4Address)InetAddresses.forString((String)address);
        Assert.assertEquals((Object)Inet4Network.fromAddress((Inet4Address)addr, (int)bits), (Object)Inet4Network.fromCidr((String)cidr));
    }

    @Test
    public void testTruncatedFromAddress() {
        TestInet4Network.assertTruncatedFromAddress("1.2.3.4", "1.2.3.4/32", 32);
        TestInet4Network.assertTruncatedFromAddress("1.2.3.4", "1.2.3.0/24", 24);
        TestInet4Network.assertTruncatedFromAddress("8.8.8.8", "8.8.8.8/32", 32);
        TestInet4Network.assertTruncatedFromAddress("8.8.8.8", "8.8.8.0/24", 24);
        TestInet4Network.assertTruncatedFromAddress("8.8.8.8", "8.8.0.0/16", 16);
        TestInet4Network.assertTruncatedFromAddress("8.8.8.8", "8.0.0.0/8", 8);
        TestInet4Network.assertTruncatedFromAddress("208.86.202.10", "208.86.202.10/32", 32);
        TestInet4Network.assertTruncatedFromAddress("208.86.202.10", "208.86.202.0/24", 24);
        TestInet4Network.assertTruncatedFromAddress("208.86.202.0", "208.86.202.0/24", 24);
    }

    private static void assertTruncatedFromAddress(String address, String cidr, int bits) {
        Inet4Address addr = (Inet4Address)InetAddresses.forString((String)address);
        Assert.assertEquals((Object)Inet4Network.truncatedFromAddress((Inet4Address)addr, (int)bits), (Object)Inet4Network.fromCidr((String)cidr));
    }

    @Test
    public void testGetBits() {
        Assert.assertEquals((int)Inet4Network.fromCidr((String)"8.0.0.0/8").getBits(), (int)8);
        Assert.assertEquals((int)Inet4Network.fromCidr((String)"8.0.0.0/24").getBits(), (int)24);
        Assert.assertEquals((int)Inet4Network.fromCidr((String)"8.0.0.0/32").getBits(), (int)32);
    }

    @Test
    public void testContainsAddress() {
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("0.0.0.0/0", "0.0.0.0"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("0.0.0.0/0", "1.2.3.4"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("0.0.0.0/0", "255.255.255.255"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("8.8.8.0/24", "8.8.8.0"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("8.8.8.0/24", "8.8.8.8"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("8.8.8.0/24", "8.8.8.255"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("202.12.128.0/18", "202.12.128.0"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("202.12.128.0/18", "202.12.128.255"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("202.12.128.0/18", "202.12.157.123"));
        Assert.assertTrue((boolean)TestInet4Network.containsAddress("202.12.128.0/18", "202.12.191.255"));
        Assert.assertFalse((boolean)TestInet4Network.containsAddress("8.8.8.0/24", "8.8.9.0"));
        Assert.assertFalse((boolean)TestInet4Network.containsAddress("8.8.8.8/32", "8.8.8.9"));
        Assert.assertFalse((boolean)TestInet4Network.containsAddress("202.12.128.0/18", "202.12.127.255"));
        Assert.assertFalse((boolean)TestInet4Network.containsAddress("202.12.128.0/18", "202.12.192.0"));
    }

    private static boolean containsAddress(String cidr, String address) {
        Inet4Address addr = (Inet4Address)InetAddresses.forString((String)address);
        return Inet4Network.fromCidr((String)cidr).containsAddress(addr);
    }

    @Test
    public void testEquals() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)Inet4Network.fromCidr((String)"8.0.0.0/8"), new Object[0]).addEquivalentGroup((Object)Inet4Network.fromCidr((String)"8.8.8.0/24"), new Object[0]).addEquivalentGroup((Object)Inet4Network.fromCidr((String)"8.8.8.8/32"), new Object[0]).check();
    }

    @Test
    public void testCompareTo() {
        EquivalenceTester.comparisonTester().addLesserGroup((Comparable)Inet4Network.fromCidr((String)"0.0.0.0/0"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.0.0.0/8"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.0.0.0/9"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.8.8.0/24"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.8.8.1/32"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.8.8.8/32"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.8.8.255/32"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"8.8.9.0/24"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"17.0.0.0/8"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"17.0.0.0/9"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"202.12.128.0/18"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"202.12.191.255/32"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"255.0.0.0/8"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"255.255.255.0/24"), (Comparable[])new Inet4Network[0]).addGreaterGroup((Comparable)Inet4Network.fromCidr((String)"255.255.255.255/32"), (Comparable[])new Inet4Network[0]).check();
    }
}

