/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server.testing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.http.client.ApacheHttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.TheServlet;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.node.NodeInfo;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTestingHttpServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitialization() throws Exception {
        DummyServlet servlet = new DummyServlet();
        ImmutableMap params = ImmutableMap.of((Object)"sampleInitParameter", (Object)"the value");
        TestingHttpServer server = this.createTestingHttpServer(servlet, (Map<String, String>)params);
        try {
            server.start();
            Assert.assertEquals((String)servlet.getSampleInitParam(), (String)"the value");
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(server.getPort()), (Comparable)Integer.valueOf(0));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequest() throws Exception {
        DummyServlet servlet = new DummyServlet();
        TestingHttpServer server = null;
        ApacheHttpClient client = null;
        try {
            server = this.createTestingHttpServer(servlet, Collections.emptyMap());
            client = new ApacheHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)));
            server.start();
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(server.getPort()), (Comparable)Integer.valueOf(0));
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(new URI(String.format("http://localhost:%d/", server.getPort()))).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((int)servlet.getCallCount(), (int)1);
        }
        finally {
            if (server != null) {
                this.closeQuietly(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilteredRequest() throws Exception {
        DummyServlet servlet = new DummyServlet();
        DummyFilter filter = new DummyFilter();
        TestingHttpServer server = null;
        ApacheHttpClient client = null;
        try {
            server = this.createTestingHttpServerWithFilter(servlet, Collections.emptyMap(), filter);
            client = new ApacheHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)));
            server.start();
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(server.getPort()), (Comparable)Integer.valueOf(0));
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(new URI(String.format("http://localhost:%d/", server.getPort()))).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((int)servlet.getCallCount(), (int)1);
            Assert.assertEquals((int)filter.getCallCount(), (int)1);
        }
        finally {
            if (server != null) {
                this.closeQuietly(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuiceInjectionWithoutFilters() throws Exception {
        TestingHttpServer server = null;
        ApacheHttpClient client = null;
        final DummyServlet servlet = new DummyServlet();
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap())), new Module(){

                public void configure(Binder binder) {
                    binder.bind(Servlet.class).annotatedWith(TheServlet.class).toInstance((Object)servlet);
                    binder.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(){}).annotatedWith(TheServlet.class).toInstance((Object)ImmutableMap.of());
                }
            }});
            server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
            server.start();
            client = new ApacheHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)));
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(new URI(String.format("http://localhost:%d/", server.getPort()))).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((int)servlet.getCallCount(), (int)1);
            if (server != null) {
                this.closeQuietly(server);
            }
        }
        catch (Throwable throwable) {
            if (server != null) {
                this.closeQuietly(server);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuiceInjectionWithFilters() throws Exception {
        TestingHttpServer server = null;
        ApacheHttpClient client = null;
        final DummyServlet servlet = new DummyServlet();
        final DummyFilter filter = new DummyFilter();
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap())), new Module(){

                public void configure(Binder binder) {
                    binder.bind(Servlet.class).annotatedWith(TheServlet.class).toInstance((Object)servlet);
                    binder.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(){}).annotatedWith(TheServlet.class).toInstance((Object)ImmutableMap.of());
                }
            }, new Module(){

                public void configure(Binder binder) {
                    Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().toInstance((Object)filter);
                }
            }});
            server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
            server.start();
            client = new ApacheHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)));
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(new URI(String.format("http://localhost:%d/", server.getPort()))).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((int)servlet.getCallCount(), (int)1);
            Assert.assertEquals((int)filter.getCallCount(), (int)1);
            if (server != null) {
                this.closeQuietly(server);
            }
        }
        catch (Throwable throwable) {
            if (server != null) {
                this.closeQuietly(server);
            }
            throw throwable;
        }
    }

    private TestingHttpServer createTestingHttpServer(DummyServlet servlet, Map<String, String> params) throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)servlet, params);
    }

    private TestingHttpServer createTestingHttpServerWithFilter(DummyServlet servlet, Map<String, String> params, DummyFilter filter) throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)servlet, params, (Set)ImmutableSet.of((Object)filter));
    }

    private void closeQuietly(TestingHttpServer server) {
        try {
            server.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class DummyFilter
    implements Filter {
        private final AtomicInteger callCount = new AtomicInteger();

        DummyFilter() {
        }

        public int getCallCount() {
            return this.callCount.get();
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.callCount.incrementAndGet();
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }
    }

    static class DummyServlet
    extends HttpServlet {
        private String sampleInitParam;
        private int callCount;

        DummyServlet() {
        }

        public synchronized void init(ServletConfig config) throws ServletException {
            this.sampleInitParam = config.getInitParameter("sampleInitParameter");
        }

        public synchronized String getSampleInitParam() {
            return this.sampleInitParam;
        }

        public synchronized int getCallCount() {
            return this.callCount;
        }

        protected synchronized void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ++this.callCount;
            resp.setStatus(200);
        }
    }
}

