/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.airlift.http.server.TheServlet;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsBinding;
import io.airlift.jaxrs.JaxrsResource;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.OverrideMethodFilter;
import io.airlift.jaxrs.ParsingExceptionMapper;
import io.airlift.jaxrs.SmileMapper;
import io.airlift.log.Logger;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JaxrsModule
implements Module {
    private static final Logger log = Logger.get(JaxrsModule.class);
    private final boolean requireExplicitBindings;

    public JaxrsModule() {
        this(false);
    }

    public JaxrsModule(boolean requireExplicitBindings) {
        this.requireExplicitBindings = requireExplicitBindings;
    }

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(Key.get(ServletContainer.class));
        JaxrsBinder.jaxrsBinder(binder).bind(JsonMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(SmileMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(ParsingExceptionMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(OverrideMethodFilter.class);
        Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
        Multibinder.newSetBinder((Binder)binder, JaxrsBinding.class, JaxrsResource.class).permitDuplicates();
    }

    @Provides
    public static ServletContainer createServletContainer(ResourceConfig resourceConfig) {
        return new ServletContainer(resourceConfig);
    }

    @Provides
    public static ResourceConfig createResourceConfig(Application application) {
        return ResourceConfig.forApplication((Application)application);
    }

    @Provides
    public Application createJaxRsApplication(@JaxrsResource Set<Object> jaxRsSingletons, @JaxrsResource Set<JaxrsBinding> jaxrsBinding, Injector injector) {
        HashSet<Key> missingBindings = new HashSet<Key>();
        ImmutableSet.Builder singletons = ImmutableSet.builder();
        singletons.addAll(jaxRsSingletons);
        while (injector != null) {
            for (Map.Entry entry : injector.getBindings().entrySet()) {
                Key key = (Key)entry.getKey();
                if (!JaxrsModule.isJaxRsBinding(key) || jaxrsBinding.contains(new JaxrsBinding(key))) continue;
                if (this.requireExplicitBindings) {
                    missingBindings.add(key);
                    continue;
                }
                log.warn("Jax-rs service %s is not explicitly bound using the JaxrsBinder", new Object[]{key});
                Object jaxRsSingleton = ((Binding)entry.getValue()).getProvider().get();
                singletons.add(jaxRsSingleton);
            }
            injector = injector.getParent();
        }
        Preconditions.checkState((!this.requireExplicitBindings || missingBindings.isEmpty() ? 1 : 0) != 0, (String)"Jax-rs services must be explicitly bound using the JaxRsBinder: ", (Object[])new Object[]{missingBindings});
        return new JaxRsApplication((Set<Object>)singletons.build());
    }

    @Provides
    @TheServlet
    public static Map<String, String> createTheServletParams() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        return initParams;
    }

    private static boolean isJaxRsBinding(Key<?> key) {
        Type type = key.getTypeLiteral().getType();
        if (!(type instanceof Class)) {
            return false;
        }
        return JaxrsModule.isJaxRsType((Class)type);
    }

    private static boolean isJaxRsType(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isAnnotationPresent(Provider.class)) {
            return true;
        }
        if (type.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (JaxrsModule.isJaxRsType(type.getSuperclass())) {
            return true;
        }
        for (Class<?> typeInterface : type.getInterfaces()) {
            if (!JaxrsModule.isJaxRsType(typeInterface)) continue;
            return true;
        }
        return false;
    }

    private static class JaxRsApplication
    extends Application {
        private final Set<Object> jaxRsSingletons;

        public JaxRsApplication(Set<Object> jaxRsSingletons) {
            this.jaxRsSingletons = jaxRsSingletons;
        }

        public Set<Object> getSingletons() {
            return this.jaxRsSingletons;
        }
    }
}

