/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.OptionalBinderBinding;
import com.google.inject.multibindings.RealElement;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Qualifier;

public abstract class OptionalBinder<T> {
    private OptionalBinder() {
    }

    public static <T> OptionalBinder<T> newOptionalBinder(Binder binder, Class<T> type) {
        return OptionalBinder.newOptionalBinder(binder, Key.get(type));
    }

    public static <T> OptionalBinder<T> newOptionalBinder(Binder binder, TypeLiteral<T> type) {
        return OptionalBinder.newOptionalBinder(binder, Key.get(type));
    }

    public static <T> OptionalBinder<T> newOptionalBinder(Binder binder, Key<T> type) {
        binder = binder.skipSources(new Class[]{OptionalBinder.class, RealOptionalBinder.class});
        RealOptionalBinder optionalBinder = new RealOptionalBinder(binder, type);
        binder.install(optionalBinder);
        return optionalBinder;
    }

    static <T> TypeLiteral<Optional<T>> optionalOf(TypeLiteral<T> type) {
        return TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{type.getType()}));
    }

    static <T> TypeLiteral<Optional<javax.inject.Provider<T>>> optionalOfJavaxProvider(TypeLiteral<T> type) {
        return TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{Types.newParameterizedType(javax.inject.Provider.class, (Type[])new Type[]{type.getType()})}));
    }

    static <T> TypeLiteral<Optional<Provider<T>>> optionalOfProvider(TypeLiteral<T> type) {
        return TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{Types.newParameterizedType(Provider.class, (Type[])new Type[]{type.getType()})}));
    }

    static <T> Key<Provider<T>> providerOf(Key<T> key) {
        ParameterizedType providerT = Types.providerOf((Type)key.getTypeLiteral().getType());
        return key.ofType((Type)providerT);
    }

    public abstract LinkedBindingBuilder<T> setDefault();

    public abstract LinkedBindingBuilder<T> setBinding();

    static abstract class BaseAnnotation
    implements Serializable,
    Annotation {
        private final String value;
        private final Class<? extends Annotation> clazz;
        private static final long serialVersionUID = 0L;

        BaseAnnotation(Class<? extends Annotation> clazz, String value) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        public String value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Actual && this.clazz == Actual.class) {
                Actual other = (Actual)o;
                return this.value.equals(other.value());
            }
            if (o instanceof Default && this.clazz == Default.class) {
                Default other = (Default)o;
                return this.value.equals(other.value());
            }
            return false;
        }

        @Override
        public String toString() {
            String string;
            String string2 = String.valueOf(String.valueOf(this.clazz.getName()));
            if (this.value.isEmpty()) {
                string = "";
            } else {
                String string3 = String.valueOf(String.valueOf(this.value));
                string = new StringBuilder(8 + string3.length()).append("(value=").append(string3).append(")").toString();
            }
            String string4 = String.valueOf(String.valueOf(string));
            return new StringBuilder(1 + string2.length() + string4.length()).append("@").append(string2).append(string4).toString();
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.clazz;
        }
    }

    static class ActualImpl
    extends BaseAnnotation
    implements Actual {
        public ActualImpl(String value) {
            super(Actual.class, value);
        }
    }

    static class DefaultImpl
    extends BaseAnnotation
    implements Default {
        public DefaultImpl(String value) {
            super(Default.class, value);
        }
    }

    static final class RealOptionalBinder<T>
    extends OptionalBinder<T>
    implements Module {
        private final Key<T> typeKey;
        private final Key<Optional<T>> optionalKey;
        private final Key<Optional<javax.inject.Provider<T>>> optionalJavaxProviderKey;
        private final Key<Optional<Provider<T>>> optionalProviderKey;
        private final Provider<Optional<Provider<T>>> optionalProviderT;
        private final Key<T> defaultKey;
        private final Key<T> actualKey;
        private Binder binder;
        private Binding<T> defaultBinding;
        private Binding<T> actualBinding;
        private Set<Dependency<?>> dependencies;
        private Set<Dependency<?>> providerDependencies;

        private RealOptionalBinder(Binder binder, Key<T> typeKey) {
            this.binder = binder;
            this.typeKey = (Key)Preconditions.checkNotNull(typeKey);
            TypeLiteral literal = typeKey.getTypeLiteral();
            this.optionalKey = typeKey.ofType(RealOptionalBinder.optionalOf(literal));
            this.optionalJavaxProviderKey = typeKey.ofType(RealOptionalBinder.optionalOfJavaxProvider(literal));
            this.optionalProviderKey = typeKey.ofType(RealOptionalBinder.optionalOfProvider(literal));
            this.optionalProviderT = binder.getProvider(this.optionalProviderKey);
            String name = RealElement.nameOf(typeKey);
            this.defaultKey = Key.get((TypeLiteral)typeKey.getTypeLiteral(), (Annotation)new DefaultImpl(name));
            this.actualKey = Key.get((TypeLiteral)typeKey.getTypeLiteral(), (Annotation)new ActualImpl(name));
            this.dependencies = ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class)));
            this.providerDependencies = ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class)));
        }

        private void addDirectTypeBinding(Binder binder) {
            binder.bind(this.typeKey).toProvider((Provider)new RealDirectTypeProvider());
        }

        @Override
        public LinkedBindingBuilder<T> setDefault() {
            Multibinder.checkConfiguration(!this.isInitialized(), "already initialized", new Object[0]);
            this.addDirectTypeBinding(this.binder);
            return this.binder.bind(this.defaultKey);
        }

        @Override
        public LinkedBindingBuilder<T> setBinding() {
            Multibinder.checkConfiguration(!this.isInitialized(), "already initialized", new Object[0]);
            this.addDirectTypeBinding(this.binder);
            return this.binder.bind(this.actualKey);
        }

        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "OptionalBinder was already initialized", new Object[0]);
            binder.bind(this.optionalProviderKey).toProvider((Provider)new RealOptionalProviderProvider());
            Key<Optional<Provider<T>>> massagedOptionalProviderKey = this.optionalProviderKey;
            binder.bind(this.optionalJavaxProviderKey).to(massagedOptionalProviderKey);
            binder.bind(this.optionalKey).toProvider((Provider)new RealOptionalKeyProvider());
        }

        private boolean matchesTypeKey(Element element, Key<?> elementKey) {
            return elementKey.equals(this.typeKey) && element instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)element).getUserSuppliedProvider() instanceof RealOptionalBinderProviderWithDependencies;
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object o) {
            return o instanceof RealOptionalBinder && ((RealOptionalBinder)o).typeKey.equals(this.typeKey);
        }

        public int hashCode() {
            return this.typeKey.hashCode();
        }

        private static abstract class RealOptionalBinderProviderWithDependencies<T>
        implements ProviderWithDependencies<T> {
            private final Object equality;

            public RealOptionalBinderProviderWithDependencies(Object equality) {
                this.equality = equality;
            }

            public boolean equals(Object obj) {
                return this.getClass() == obj.getClass() && this.equality.equals(((RealOptionalBinderProviderWithDependencies)obj).equality);
            }

            public int hashCode() {
                return this.equality.hashCode();
            }
        }

        final class RealOptionalKeyProvider
        extends RealOptionalBinderProviderWithDependencies<Optional<T>>
        implements ProviderWithExtensionVisitor<Optional<T>>,
        OptionalBinderBinding<Optional<T>>,
        Provider<Optional<T>> {
            private RealOptionalKeyProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            public Optional<T> get() {
                Optional optional = (Optional)RealOptionalBinder.this.optionalProviderT.get();
                if (optional.isPresent()) {
                    return Optional.fromNullable((Object)((Provider)optional.get()).get());
                }
                return Optional.absent();
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.dependencies;
            }

            public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> visitor, ProviderInstanceBinding<? extends B> binding) {
                if (visitor instanceof MultibindingsTargetVisitor) {
                    return (R)((MultibindingsTargetVisitor)visitor).visit(this);
                }
                return (R)visitor.visit(binding);
            }

            @Override
            public Key<Optional<T>> getKey() {
                return RealOptionalBinder.this.optionalKey;
            }

            @Override
            public Binding<?> getActualBinding() {
                if (RealOptionalBinder.this.isInitialized()) {
                    return RealOptionalBinder.this.actualBinding;
                }
                throw new UnsupportedOperationException("getActualBinding() not supported from Elements.getElements, requires an Injector.");
            }

            @Override
            public Binding<?> getDefaultBinding() {
                if (RealOptionalBinder.this.isInitialized()) {
                    return RealOptionalBinder.this.defaultBinding;
                }
                throw new UnsupportedOperationException("getDefaultBinding() not supported from Elements.getElements, requires an Injector.");
            }

            @Override
            public boolean containsElement(Element element) {
                Key elementKey;
                if (element instanceof Binding) {
                    elementKey = ((Binding)element).getKey();
                } else if (element instanceof ProviderLookup) {
                    elementKey = ((ProviderLookup)element).getKey();
                } else {
                    return false;
                }
                return elementKey.equals((Object)RealOptionalBinder.this.optionalKey) || elementKey.equals((Object)RealOptionalBinder.this.optionalProviderKey) || elementKey.equals((Object)RealOptionalBinder.this.optionalJavaxProviderKey) || elementKey.equals((Object)RealOptionalBinder.this.defaultKey) || elementKey.equals((Object)RealOptionalBinder.this.actualKey) || RealOptionalBinder.this.matchesTypeKey(element, elementKey);
            }
        }

        final class RealOptionalProviderProvider
        extends RealOptionalBinderProviderWithDependencies<Optional<Provider<T>>> {
            private Optional<Provider<T>> optional;

            private RealOptionalProviderProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            @Toolable
            @Inject
            void initialize(Injector injector) {
                RealOptionalBinder.this.binder = null;
                RealOptionalBinder.this.actualBinding = injector.getExistingBinding(RealOptionalBinder.this.actualKey);
                RealOptionalBinder.this.defaultBinding = injector.getExistingBinding(RealOptionalBinder.this.defaultKey);
                Binding userBinding = injector.getExistingBinding(RealOptionalBinder.this.typeKey);
                Binding binding = null;
                if (RealOptionalBinder.this.actualBinding != null) {
                    binding = RealOptionalBinder.this.actualBinding;
                } else if (RealOptionalBinder.this.defaultBinding != null) {
                    binding = RealOptionalBinder.this.defaultBinding;
                } else if (userBinding != null) {
                    binding = userBinding;
                    RealOptionalBinder.this.actualBinding = userBinding;
                }
                if (binding != null) {
                    this.optional = Optional.of((Object)binding.getProvider());
                    RealOptionalBinder.this.dependencies = (Set)ImmutableSet.of((Object)Dependency.get((Key)binding.getKey()));
                    RealOptionalBinder.this.providerDependencies = (Set)ImmutableSet.of((Object)Dependency.get(OptionalBinder.providerOf(binding.getKey())));
                } else {
                    this.optional = Optional.absent();
                    RealOptionalBinder.this.dependencies = (Set)ImmutableSet.of();
                    RealOptionalBinder.this.providerDependencies = (Set)ImmutableSet.of();
                }
            }

            public Optional<Provider<T>> get() {
                return this.optional;
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.providerDependencies;
            }
        }

        final class RealDirectTypeProvider
        extends RealOptionalBinderProviderWithDependencies<T> {
            private RealDirectTypeProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            public T get() {
                Optional optional = (Optional)RealOptionalBinder.this.optionalProviderT.get();
                if (optional.isPresent()) {
                    return ((Provider)optional.get()).get();
                }
                return null;
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.dependencies;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Actual {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Default {
        public String value();
    }

    static enum Source {
        DEFAULT,
        ACTUAL;

    }
}

