/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.ZoneOffset;

public class OffsetTimeDeserializer
extends JSR310DeserializerBase<OffsetTime> {
    private static final long serialVersionUID = 1L;
    public static final OffsetTimeDeserializer INSTANCE = new OffsetTimeDeserializer();

    private OffsetTimeDeserializer() {
        super(OffsetTime.class);
    }

    public OffsetTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case START_ARRAY: {
                if (parser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int hour = parser.getIntValue();
                parser.nextToken();
                int minute = parser.getIntValue();
                int second = 0;
                int partialSecond = 0;
                if (parser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                    second = parser.getIntValue();
                    if (parser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                        partialSecond = parser.getIntValue();
                        if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            partialSecond *= 1000000;
                        }
                        parser.nextToken();
                    }
                }
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    return OffsetTime.of(hour, minute, second, partialSecond, ZoneOffset.of(parser.getText()));
                }
                throw context.wrongTokenException(parser, JsonToken.VALUE_STRING, "Expected string");
            }
            case VALUE_STRING: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return OffsetTime.parse(string);
            }
        }
        throw context.wrongTokenException(parser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

