/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.SpinLock;

public class HttpExchange {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final AtomicReference<HttpChannel> channel = new AtomicReference();
    private final HttpDestination destination;
    private final HttpRequest request;
    private final List<Response.ResponseListener> listeners;
    private final HttpResponse response;
    private final SpinLock _lock = new SpinLock();
    private State requestState = State.PENDING;
    private State responseState = State.PENDING;
    private Throwable requestFailure;
    private Throwable responseFailure;

    public HttpExchange(HttpDestination destination, HttpRequest request, List<Response.ResponseListener> listeners) {
        this.destination = destination;
        this.request = request;
        this.listeners = listeners;
        this.response = new HttpResponse(request, listeners);
        HttpConversation conversation = request.getConversation();
        conversation.getExchanges().offer(this);
        conversation.updateResponseListeners(null);
    }

    public HttpConversation getConversation() {
        return this.request.getConversation();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public Throwable getRequestFailure() {
        try (SpinLock.Lock lock = this._lock.lock();){
            Throwable throwable = this.requestFailure;
            return throwable;
        }
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Throwable getResponseFailure() {
        try (SpinLock.Lock lock = this._lock.lock();){
            Throwable throwable = this.responseFailure;
            return throwable;
        }
    }

    public void associate(HttpChannel channel) {
        if (!this.channel.compareAndSet(null, channel)) {
            this.request.abort(new IllegalStateException());
        }
    }

    public void disassociate(HttpChannel channel) {
        if (!this.channel.compareAndSet(channel, null)) {
            this.request.abort(new IllegalStateException());
        }
    }

    public boolean requestComplete() {
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this.requestState != State.PENDING) {
                boolean bl = false;
                return bl;
            }
            this.requestState = State.COMPLETED;
            boolean bl = true;
            return bl;
        }
    }

    public boolean responseComplete() {
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this.responseState != State.PENDING) {
                boolean bl = false;
                return bl;
            }
            this.responseState = State.COMPLETED;
            boolean bl = true;
            return bl;
        }
    }

    public Result terminateRequest(Throwable failure) {
        try (SpinLock.Lock lock = this._lock.lock();){
            this.requestState = State.TERMINATED;
            this.requestFailure = failure;
            if (State.TERMINATED.equals((Object)this.responseState)) {
                Result result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
                return result;
            }
        }
        return null;
    }

    public Result terminateResponse(Throwable failure) {
        try (SpinLock.Lock lock = this._lock.lock();){
            this.responseState = State.TERMINATED;
            this.responseFailure = failure;
            if (State.TERMINATED.equals((Object)this.requestState)) {
                Result result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
                return result;
            }
        }
        return null;
    }

    public boolean abort(Throwable cause) {
        if (this.destination.remove(this)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting while queued {}: {}", new Object[]{this, cause});
            }
            return this.fail(cause);
        }
        HttpChannel channel = this.channel.get();
        if (channel == null) {
            return this.fail(cause);
        }
        boolean aborted = channel.abort(cause);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Aborted ({}) while active {}: {}", new Object[]{aborted, this, cause});
        }
        return aborted;
    }

    private boolean fail(Throwable cause) {
        boolean notify = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            if (!Boolean.TRUE.equals((Object)this.requestState)) {
                this.requestState = State.TERMINATED;
                notify = true;
                this.requestFailure = cause;
            }
            if (!Boolean.TRUE.equals((Object)this.responseState)) {
                this.responseState = State.TERMINATED;
                notify = true;
                this.responseFailure = cause;
            }
        }
        if (notify) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failing {}: {}", new Object[]{this, cause});
            }
            this.destination.getRequestNotifier().notifyFailure(this.request, cause);
            List<Response.ResponseListener> listeners = this.getConversation().getResponseListeners();
            ResponseNotifier responseNotifier = this.destination.getResponseNotifier();
            responseNotifier.notifyFailure(listeners, (Response)this.response, cause);
            responseNotifier.notifyComplete(listeners, new Result(this.request, cause, this.response, cause));
            return true;
        }
        return false;
    }

    public void resetResponse() {
        try (SpinLock.Lock lock = this._lock.lock();){
            this.responseState = State.PENDING;
            this.responseFailure = null;
        }
    }

    public void proceed(Throwable failure) {
        HttpChannel channel = this.channel.get();
        if (channel != null) {
            channel.proceed(this, failure);
        }
    }

    public String toString() {
        try (SpinLock.Lock lock = this._lock.lock();){
            String string = String.format("%s@%x req=%s/%s res=%s/%s", new Object[]{HttpExchange.class.getSimpleName(), this.hashCode(), this.requestState, this.requestFailure, this.responseState, this.responseFailure});
            return string;
        }
    }

    static enum State {
        PENDING,
        COMPLETED,
        TERMINATED;

    }
}

