/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpClientModule;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.TraceTokenRequestFilter;
import java.lang.annotation.Annotation;
import java.util.Collection;

@Beta
public class HttpClientBinder {
    private final Binder binder;

    private HttpClientBinder(Binder binder) {
        this.binder = (Binder)Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
    }

    public static HttpClientBinder httpClientBinder(Binder binder) {
        return new HttpClientBinder(binder);
    }

    public HttpClientBindingBuilder bindHttpClient(String name, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        return this.createBindingBuilder(new HttpClientModule(name, annotation));
    }

    private HttpClientBindingBuilder createBindingBuilder(HttpClientModule module) {
        this.binder.install((Module)module);
        return new HttpClientBindingBuilder(module, (Multibinder<HttpRequestFilter>)Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)module.getFilterQualifier()));
    }

    public static class HttpClientBindingBuilder {
        private final HttpClientModule module;
        private final Multibinder<HttpRequestFilter> multibinder;

        public HttpClientBindingBuilder(HttpClientModule module, Multibinder<HttpRequestFilter> multibinder) {
            this.module = module;
            this.multibinder = multibinder;
        }

        public HttpClientBindingBuilder withAlias(Class<? extends Annotation> alias) {
            this.module.addAlias(alias);
            return this;
        }

        public HttpClientBindingBuilder withAliases(Collection<Class<? extends Annotation>> aliases) {
            for (Class<? extends Annotation> annotation : aliases) {
                this.module.addAlias(annotation);
            }
            return this;
        }

        public HttpClientBindingBuilder withConfigDefaults(ConfigDefaults<HttpClientConfig> configDefaults) {
            this.module.withConfigDefaults(configDefaults);
            return this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.multibinder.addBinding();
        }

        public HttpClientBindingBuilder withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.multibinder.addBinding().to(filterClass);
            return this;
        }

        public HttpClientBindingBuilder withTracing() {
            return this.withFilter(TraceTokenRequestFilter.class);
        }

        public HttpClientBindingBuilder withPrivateIoThreadPool() {
            this.module.withPrivateIoThreadPool();
            return this;
        }
    }
}

