/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Throwables;
import com.google.common.net.InetAddresses;
import com.google.inject.Inject;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.node.NodeInfo;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;

public class HttpServerInfo {
    private final URI httpUri;
    private final URI httpExternalUri;
    private final URI httpsUri;
    private final URI httpsExternalUri;
    private final URI adminUri;
    private final URI adminExternalUri;

    @Inject
    public HttpServerInfo(HttpServerConfig config, NodeInfo nodeInfo) {
        if (config.isHttpEnabled()) {
            this.httpUri = HttpServerInfo.buildUri("http", InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()), config.getHttpPort());
            this.httpExternalUri = HttpServerInfo.buildUri("http", nodeInfo.getExternalAddress(), this.httpUri.getPort());
        } else {
            this.httpUri = null;
            this.httpExternalUri = null;
        }
        if (config.isHttpsEnabled()) {
            this.httpsUri = HttpServerInfo.buildUri("https", InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()), config.getHttpsPort());
            this.httpsExternalUri = HttpServerInfo.buildUri("https", nodeInfo.getExternalAddress(), this.httpsUri.getPort());
        } else {
            this.httpsUri = null;
            this.httpsExternalUri = null;
        }
        if (config.isAdminEnabled()) {
            if (config.isHttpsEnabled()) {
                this.adminUri = HttpServerInfo.buildUri("https", InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()), config.getAdminPort());
                this.adminExternalUri = HttpServerInfo.buildUri("https", nodeInfo.getExternalAddress(), this.adminUri.getPort());
            } else {
                this.adminUri = HttpServerInfo.buildUri("http", InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()), config.getAdminPort());
                this.adminExternalUri = HttpServerInfo.buildUri("http", nodeInfo.getExternalAddress(), this.adminUri.getPort());
            }
        } else {
            this.adminUri = null;
            this.adminExternalUri = null;
        }
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public URI getHttpExternalUri() {
        return this.httpExternalUri;
    }

    public URI getHttpsUri() {
        return this.httpsUri;
    }

    public URI getHttpsExternalUri() {
        return this.httpsExternalUri;
    }

    public URI getAdminUri() {
        return this.adminUri;
    }

    public URI getAdminExternalUri() {
        return this.adminExternalUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI buildUri(String scheme, String host, int port) {
        try {
            if (port == 0) {
                try (ServerSocket socket = new ServerSocket();){
                    socket.bind(new InetSocketAddress(0));
                    port = socket.getLocalPort();
                }
            }
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

