/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.sample.Person;
import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class PersonRepresentation {
    private final Person person;
    private final URI self;

    public static PersonRepresentation from(Person person, URI self) {
        return new PersonRepresentation(person, self);
    }

    @JsonCreator
    public PersonRepresentation(@JsonProperty(value="email") String email, @JsonProperty(value="name") String name, @JsonProperty(value="self") URI self) {
        this(new Person(email, name), self);
    }

    private PersonRepresentation(Person person, URI self) {
        this.person = person;
        this.self = self;
    }

    @JsonProperty
    @NotNull(message="is missing")
    @Pattern(regexp="[^@]+@[^@]+", message="is malformed")
    public String getEmail() {
        return this.person.getEmail();
    }

    @JsonProperty
    @NotNull(message="is missing")
    public String getName() {
        return this.person.getName();
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    public Person toPerson() {
        return this.person;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonRepresentation that = (PersonRepresentation)o;
        if (this.person != null ? !this.person.equals(that.person) : that.person != null) {
            return false;
        }
        return !(this.self != null ? !this.self.equals(that.self) : that.self != null);
    }

    public int hashCode() {
        int result = this.person != null ? this.person.hashCode() : 0;
        result = 31 * result + (this.self != null ? this.self.hashCode() : 0);
        return result;
    }
}

