/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import io.airlift.configuration.ConfigDefaultsHolder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareProvider;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ElementsIterator;
import io.airlift.configuration.WarningsMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Configuration {
    private Configuration() {
    }

    public static List<Message> processConfiguration(ConfigurationFactory configurationFactory, WarningsMonitor warningsMonitor, Module ... modules) {
        return Configuration.processConfiguration(configurationFactory, warningsMonitor, (Collection<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public static List<Message> processConfiguration(final ConfigurationFactory configurationFactory, final WarningsMonitor warningsMonitor, Collection<? extends Module> modules) {
        modules.stream().filter(ConfigurationAwareModule.class::isInstance).map(ConfigurationAwareModule.class::cast).forEach(module -> module.setConfigurationFactory(configurationFactory));
        final ArrayList messages = Lists.newArrayList();
        ElementsIterator elementsIterator = new ElementsIterator(modules);
        for (Element element : elementsIterator) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    InstanceBinding instanceBinding;
                    if (binding instanceof InstanceBinding && (instanceBinding = (InstanceBinding)binding).getInstance() instanceof ConfigDefaultsHolder) {
                        configurationFactory.registerConfigDefaults((ConfigDefaultsHolder)instanceBinding.getInstance());
                    }
                    return null;
                }
            });
        }
        for (Element element : elementsIterator) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getProviderInstance()) instanceof ConfigurationAwareProvider) {
                        ConfigurationAwareProvider configurationProvider = (ConfigurationAwareProvider)provider;
                        configurationProvider.setConfigurationFactory(configurationFactory);
                        configurationProvider.setWarningsMonitor(warningsMonitor);
                        try {
                            configurationProvider.get();
                        }
                        catch (ConfigurationException e) {
                            for (Message message : e.getErrorMessages()) {
                                messages.add(new Message(Collections.singletonList(binding.getSource()), message.getMessage(), message.getCause()));
                            }
                        }
                    }
                    return null;
                }
            });
        }
        return messages;
    }
}

