/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.spnego;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.sun.security.auth.module.Krb5LoginModule;
import io.airlift.http.client.spnego.UriUtil;
import io.airlift.log.Logger;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoAuthentication
implements Authentication {
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();
    private static final Logger LOG = Logger.get(SpnegoAuthentication.class);
    private static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    private static final Oid SPNEGO_OID;
    private static final Oid KERBEROS_OID;
    private final LoginContext loginContext;
    private final GSSCredential clientCredential;
    private final String remoteServiceName;

    public SpnegoAuthentication(final File keytab, File kerberosConfig, final File credentialCache, final String principal, String remoteServiceName) {
        Objects.requireNonNull(kerberosConfig, "kerberosConfig is null");
        Objects.requireNonNull(remoteServiceName, "remoteServiceName is null");
        this.remoteServiceName = remoteServiceName;
        System.setProperty("java.security.krb5.conf", kerberosConfig.getAbsolutePath());
        try {
            this.loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
                    optionsBuilder.put((Object)"refreshKrb5Config", (Object)"true");
                    optionsBuilder.put((Object)"doNotPrompt", (Object)"true");
                    if (LOG.isDebugEnabled()) {
                        optionsBuilder.put((Object)"debug", (Object)"true");
                    }
                    if (keytab != null) {
                        optionsBuilder.put((Object)"useKeytab", (Object)"true");
                        optionsBuilder.put((Object)"keytab", (Object)keytab.getAbsolutePath());
                    }
                    if (credentialCache != null) {
                        optionsBuilder.put((Object)"ticketCache", (Object)credentialCache.getAbsolutePath());
                        optionsBuilder.put((Object)"useTicketCache", (Object)"true");
                        optionsBuilder.put((Object)"renewTGT", (Object)"true");
                    }
                    if (principal != null) {
                        optionsBuilder.put((Object)"principal", (Object)principal);
                    }
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)optionsBuilder.build())};
                }
            });
            this.loginContext.login();
            Subject subject = this.loginContext.getSubject();
            Principal clientPrincipal = subject.getPrincipals().iterator().next();
            this.clientCredential = SpnegoAuthentication.doAs(subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
        }
        catch (LoginException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void shutdown() {
        try {
            this.loginContext.logout();
        }
        catch (LoginException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public Authentication.Result authenticate(Request request, ContentResponse response, final Authentication.HeaderInfo headerInfo, Attributes attributes) {
        final URI normalizedUri = UriUtil.normalizedUri(request.getURI());
        return new Authentication.Result(){

            public URI getURI() {
                return normalizedUri;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Request request) {
                String servicePrincipal = SpnegoAuthentication.makeServicePrincipal(SpnegoAuthentication.this.remoteServiceName, normalizedUri.getHost());
                GSSContext context = (GSSContext)SpnegoAuthentication.doAs(SpnegoAuthentication.this.loginContext.getSubject(), () -> {
                    GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, null), SPNEGO_OID, SpnegoAuthentication.this.clientCredential, Integer.MAX_VALUE);
                    result.requestMutualAuth(true);
                    result.requestConf(true);
                    result.requestInteg(true);
                    result.requestCredDeleg(false);
                    return result;
                });
                try {
                    byte[] token = context.initSecContext(new byte[0], 0, 0);
                    if (token != null) {
                        request.header(headerInfo.getHeader(), String.format("%s %s", NEGOTIATE, Base64.getEncoder().encodeToString(token)));
                    } else {
                        LOG.debug("No token generated from GSS context for %s", new Object[]{request.getURI()});
                    }
                }
                catch (GSSException e) {
                    LOG.debug((Throwable)e, "Failed to establish GSSContext for request %s", new Object[]{request.getURI()});
                }
                finally {
                    try {
                        context.dispose();
                    }
                    catch (GSSException gSSException) {}
                }
            }
        };
    }

    public boolean matches(String type, URI uri, String realm) {
        return NEGOTIATE.equalsIgnoreCase(type);
    }

    private static String makeServicePrincipal(String serviceName, String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            String fullHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
            Preconditions.checkState((!fullHostName.equalsIgnoreCase("localhost") ? 1 : 0) != 0, (Object)"Fully qualified name of localhost should not resolve to 'localhost'. System configuration error?");
            return String.format("%s/%s", serviceName, fullHostName.toLowerCase(Locale.US));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) {
        return (T)Subject.doAs(subject, () -> {
            try {
                return action.get();
            }
            catch (GSSException e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    static {
        try {
            SPNEGO_OID = new Oid("1.3.6.1.5.5.2");
            KERBEROS_OID = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

