/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.collect.ImmutableList;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.InMemoryEventClient;
import io.airlift.jaxrs.testing.MockUriInfo;
import io.airlift.sample.Person;
import io.airlift.sample.PersonEvent;
import io.airlift.sample.PersonRepresentation;
import io.airlift.sample.PersonResource;
import io.airlift.sample.PersonStore;
import io.airlift.sample.StoreConfig;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPersonResource {
    private PersonResource resource;
    private PersonStore store;
    private InMemoryEventClient eventClient;

    @BeforeMethod
    public void setup() {
        this.eventClient = new InMemoryEventClient();
        this.store = new PersonStore(new StoreConfig(), (EventClient)this.eventClient);
        this.resource = new PersonResource(this.store);
    }

    @Test
    public void testNotFound() {
        Response response = this.resource.get("foo", MockUriInfo.from((URI)URI.create("http://localhost/v1/person/1")));
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testGet() {
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        Response response = this.resource.get("foo", MockUriInfo.from((URI)URI.create("http://localhost/v1/person/1")));
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
        Assert.assertEquals((Object)response.getEntity(), (Object)new PersonRepresentation("foo@example.com", "Mr Foo", URI.create("http://localhost/v1/person/1")));
        Assert.assertNull((Object)response.getMetadata().get((Object)"Content-Type"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testGetNull() {
        this.resource.get(null, MockUriInfo.from((URI)URI.create("http://localhost/v1/person/1")));
    }

    @Test
    public void testAdd() {
        Response response = this.resource.put("foo", new PersonRepresentation("foo@example.com", "Mr Foo", null));
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode());
        Assert.assertNull((Object)response.getEntity());
        Assert.assertNull((Object)response.getMetadata().get((Object)"Content-Type"));
        Assert.assertEquals((Object)this.store.get("foo"), (Object)new Person("foo@example.com", "Mr Foo"));
        Assert.assertEquals((Collection)this.eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPutNullId() {
        this.resource.put(null, new PersonRepresentation("foo@example.com", "Mr Foo", null));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPutNullValue() {
        this.resource.put("foo", null);
    }

    @Test
    public void testReplace() {
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        Response response = this.resource.put("foo", new PersonRepresentation("bar@example.com", "Mr Bar", null));
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        Assert.assertNull((Object)response.getEntity());
        Assert.assertNull((Object)response.getMetadata().get((Object)"Content-Type"));
        Assert.assertEquals((Object)this.store.get("foo"), (Object)new Person("bar@example.com", "Mr Bar"));
        Assert.assertEquals((Collection)this.eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo")), (Object)PersonEvent.personUpdated((String)"foo", (Person)new Person("bar@example.com", "Mr Bar"))));
    }

    @Test
    public void testDelete() {
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        Response response = this.resource.delete("foo");
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        Assert.assertNull((Object)response.getEntity());
        Assert.assertNull((Object)this.store.get("foo"));
        Assert.assertEquals((Collection)this.eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo")), (Object)PersonEvent.personRemoved((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test
    public void testDeleteMissing() {
        Response response = this.resource.delete("foo");
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        Assert.assertNull((Object)response.getEntity());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testDeleteNullId() {
        this.resource.delete(null);
    }
}

