/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.collect.ImmutableList;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.InMemoryEventClient;
import io.airlift.sample.Person;
import io.airlift.sample.PersonEvent;
import io.airlift.sample.PersonStore;
import io.airlift.sample.StoreConfig;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPersonStore {
    @Test
    public void testStartsEmpty() {
        PersonStore store = new PersonStore(new StoreConfig(), (EventClient)new InMemoryEventClient());
        Assert.assertTrue((boolean)store.getAll().isEmpty());
    }

    @Test
    public void testTtl() throws InterruptedException {
        StoreConfig config = new StoreConfig();
        config.setTtl(new Duration(1.0, TimeUnit.MILLISECONDS));
        PersonStore store = new PersonStore(config, (EventClient)new InMemoryEventClient());
        store.put("foo", new Person("foo@example.com", "Mr Foo"));
        Thread.sleep(2L);
        Assert.assertNull((Object)store.get("foo"));
    }

    @Test
    public void testPut() {
        InMemoryEventClient eventClient = new InMemoryEventClient();
        PersonStore store = new PersonStore(new StoreConfig(), (EventClient)eventClient);
        store.put("foo", new Person("foo@example.com", "Mr Foo"));
        Assert.assertEquals((Object)new Person("foo@example.com", "Mr Foo"), (Object)store.get("foo"));
        Assert.assertEquals((int)store.getAll().size(), (int)1);
        Assert.assertEquals((Collection)eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test
    public void testIdempotentPut() {
        InMemoryEventClient eventClient = new InMemoryEventClient();
        PersonStore store = new PersonStore(new StoreConfig(), (EventClient)eventClient);
        store.put("foo", new Person("foo@example.com", "Mr Foo"));
        store.put("foo", new Person("foo@example.com", "Mr Bar"));
        Assert.assertEquals((Object)new Person("foo@example.com", "Mr Bar"), (Object)store.get("foo"));
        Assert.assertEquals((int)store.getAll().size(), (int)1);
        Assert.assertEquals((Collection)eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo")), (Object)PersonEvent.personUpdated((String)"foo", (Person)new Person("foo@example.com", "Mr Bar"))));
    }

    @Test
    public void testDelete() {
        InMemoryEventClient eventClient = new InMemoryEventClient();
        PersonStore store = new PersonStore(new StoreConfig(), (EventClient)eventClient);
        store.put("foo", new Person("foo@example.com", "Mr Foo"));
        store.delete("foo");
        Assert.assertNull((Object)store.get("foo"));
        Assert.assertTrue((boolean)store.getAll().isEmpty());
        Assert.assertEquals((Collection)eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo")), (Object)PersonEvent.personRemoved((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test
    public void testIdempotentDelete() {
        InMemoryEventClient eventClient = new InMemoryEventClient();
        PersonStore store = new PersonStore(new StoreConfig(), (EventClient)eventClient);
        store.put("foo", new Person("foo@example.com", "Mr Foo"));
        store.delete("foo");
        Assert.assertTrue((boolean)store.getAll().isEmpty());
        Assert.assertNull((Object)store.get("foo"));
        store.delete("foo");
        Assert.assertTrue((boolean)store.getAll().isEmpty());
        Assert.assertNull((Object)store.get("foo"));
        Assert.assertEquals((Collection)eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo")), (Object)PersonEvent.personRemoved((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test
    public void testGetAll() {
        PersonStore store = new PersonStore(new StoreConfig(), (EventClient)new InMemoryEventClient());
        store.put("foo", new Person("foo@example.com", "Mr Foo"));
        store.put("bar", new Person("bar@example.com", "Mr Bar"));
        Assert.assertEquals((int)store.getAll().size(), (int)2);
        Assert.assertEquals((Collection)store.getAll(), Arrays.asList(new Person("foo@example.com", "Mr Foo"), new Person("bar@example.com", "Mr Bar")));
    }
}

