/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.InMemoryEventClient;
import io.airlift.event.client.InMemoryEventModule;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.sample.MainModule;
import io.airlift.sample.Person;
import io.airlift.sample.PersonEvent;
import io.airlift.sample.PersonStore;
import io.airlift.testing.Assertions;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestServer {
    private static final int NOT_ALLOWED = 405;
    private HttpClient client;
    private TestingHttpServer server;
    private PersonStore store;
    private final JsonCodec<Map<String, Object>> mapCodec = JsonCodec.mapJsonCodec(String.class, Object.class);
    private final JsonCodec<List<Object>> listCodec = JsonCodec.listJsonCodec(Object.class);
    private InMemoryEventClient eventClient;
    private LifeCycleManager lifeCycleManager;

    @BeforeMethod
    public void setup() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new InMemoryEventModule(), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(true), new MainModule()});
        Injector injector = app.strictConfig().doNotInitializeLogging().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
        this.store = (PersonStore)injector.getInstance(PersonStore.class);
        this.eventClient = (InMemoryEventClient)injector.getInstance(InMemoryEventClient.class);
        this.client = new JettyHttpClient();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        try {
            if (this.lifeCycleManager != null) {
                this.lifeCycleManager.stop();
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
            throw throwable;
        }
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testEmpty() throws Exception {
        List response = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.uriFor("/v1/person")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.listCodec));
        Assert.assertEquals((Collection)response, Collections.emptyList());
    }

    @Test
    public void testGetAll() throws IOException, ExecutionException, InterruptedException {
        this.store.put("bar", new Person("bar@example.com", "Mr Bar"));
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        List expected = (List)this.listCodec.fromJson(Resources.toString((URL)Resources.getResource((String)"list.json"), (Charset)Charsets.UTF_8));
        List actual = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.uriFor("/v1/person")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.listCodec));
        Assertions.assertEqualsIgnoreOrder((Iterable)expected, (Iterable)actual);
    }

    @Test
    public void testGetSingle() throws IOException, ExecutionException, InterruptedException {
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        URI requestUri = this.uriFor("/v1/person/foo");
        Map expected = (Map)this.mapCodec.fromJson(Resources.toString((URL)Resources.getResource((String)"single.json"), (Charset)Charsets.UTF_8));
        expected.put("self", requestUri.toString());
        Map actual = (Map)this.client.execute(Request.Builder.prepareGet().setUri(requestUri).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.mapCodec));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testPut() throws IOException, ExecutionException, InterruptedException {
        String json = Resources.toString((URL)Resources.getResource((String)"single.json"), (Charset)Charsets.UTF_8);
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.preparePut().setUri(this.uriFor("/v1/person/foo")).addHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)json, (Charset)Charsets.UTF_8)).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.CREATED.getStatusCode());
        Assert.assertEquals((Object)this.store.get("foo"), (Object)new Person("foo@example.com", "Mr Foo"));
        Assert.assertEquals((Collection)this.eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test
    public void testDelete() throws IOException, ExecutionException, InterruptedException {
        this.store.put("foo", new Person("foo@example.com", "Mr Foo"));
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareDelete().setUri(this.uriFor("/v1/person/foo")).addHeader("Content-Type", "application/json").build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.NO_CONTENT.getStatusCode());
        Assert.assertNull((Object)this.store.get("foo"));
        Assert.assertEquals((Collection)this.eventClient.getEvents(), (Collection)ImmutableList.of((Object)PersonEvent.personAdded((String)"foo", (Person)new Person("foo@example.com", "Mr Foo")), (Object)PersonEvent.personRemoved((String)"foo", (Person)new Person("foo@example.com", "Mr Foo"))));
    }

    @Test
    public void testDeleteMissing() throws IOException, ExecutionException, InterruptedException {
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareDelete().setUri(this.uriFor("/v1/person/foo")).addHeader("Content-Type", "application/json").build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testPostNotAllowed() throws IOException, ExecutionException, InterruptedException {
        String json = Resources.toString((URL)Resources.getResource((String)"single.json"), (Charset)Charsets.UTF_8);
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.preparePost().setUri(this.uriFor("/v1/person/foo")).addHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)json, (Charset)Charsets.UTF_8)).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)405);
        Assert.assertNull((Object)this.store.get("foo"));
    }

    private URI uriFor(String path) {
        return this.server.getBaseUrl().resolve(path);
    }
}

