/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.sample.StoreConfig;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestStoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((StoreConfig)ConfigAssertions.recordDefaults(StoreConfig.class)).setTtl(new Duration(1.0, TimeUnit.HOURS)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"store.ttl", (Object)"2h").build();
        StoreConfig expected = new StoreConfig().setTtl(new Duration(2.0, TimeUnit.HOURS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testDeprecatedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"store.ttl", (Object)"1h").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"store.ttl-in-ms", (Object)"3600000").build();
        ConfigAssertions.assertDeprecatedEquivalence(StoreConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties});
    }
}

