/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class SliceStreamUtils {
    private SliceStreamUtils() {
    }

    public static void copyStreamFully(InputStream in, OutputStream out, int length) throws IOException {
        byte[] bytes = new byte[4096];
        while (length > 0) {
            int newBytes = in.read(bytes, 0, Math.min(bytes.length, length));
            if (newBytes < 0) {
                throw new EOFException();
            }
            out.write(bytes, 0, newBytes);
            length -= newBytes;
        }
    }
}

