/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.airlift.http.client.jetty.JettyIoPoolConfig;
import java.io.Closeable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public final class JettyIoPool
implements Closeable {
    private final String name;
    private final QueuedThreadPool executor;
    private final ByteBufferPool byteBufferPool;
    private final Scheduler scheduler;

    public JettyIoPool(String name, JettyIoPoolConfig config) {
        this.name = name;
        try {
            String baseName = "http-client-" + name;
            ThreadGroup threadGroup = new ThreadGroup(baseName);
            QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads(), config.getMinThreads(), 60000, null, threadGroup);
            threadPool.setName(baseName);
            threadPool.setDaemon(true);
            threadPool.start();
            threadPool.setStopTimeout(2000L);
            this.executor = threadPool;
            this.scheduler = new ScheduledExecutorScheduler(baseName + "-scheduler", true, Thread.currentThread().getContextClassLoader(), threadGroup);
            this.scheduler.start();
            this.byteBufferPool = new MappedByteBufferPool();
        }
        catch (Exception e) {
            this.close();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            JettyIoPool.closeQuietly((LifeCycle)this.executor);
        }
        finally {
            JettyIoPool.closeQuietly((LifeCycle)this.scheduler);
        }
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

