/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceState;
import io.airlift.node.NodeInfo;
import java.util.Map;
import java.util.UUID;

public class ServiceAnnouncement {
    private final UUID id = UUID.randomUUID();
    private final String type;
    private final Map<String, String> properties;

    private ServiceAnnouncement(String type, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.type = type;
        this.properties = ImmutableMap.copyOf(properties);
    }

    @JsonProperty
    public UUID getId() {
        return this.id;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAnnouncement that = (ServiceAnnouncement)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("properties", this.properties).toString();
    }

    public ServiceDescriptor toServiceDescriptor(NodeInfo nodeInfo) {
        return ServiceDescriptor.serviceDescriptor(this.type).setId(this.id).setNodeInfo(nodeInfo).setLocation(nodeInfo.getLocation()).setState(ServiceState.RUNNING).addProperties(this.properties).build();
    }

    public static ServiceAnnouncementBuilder serviceAnnouncement(String type) {
        return new ServiceAnnouncementBuilder(type);
    }

    public static class ServiceAnnouncementBuilder {
        private final String type;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private ServiceAnnouncementBuilder(String type) {
            this.type = type;
        }

        public ServiceAnnouncementBuilder addProperty(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"key is null");
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public ServiceAnnouncementBuilder addProperties(Map<String, String> properties) {
            Preconditions.checkNotNull(properties, (Object)"properties is null");
            this.properties.putAll(properties);
            return this;
        }

        public ServiceAnnouncement build() {
            return new ServiceAnnouncement(this.type, (Map)this.properties.build());
        }
    }
}

