/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;

@Singleton
public class ParamConverterFactory
implements ParamConverterProvider {
    private List<ParamConverterProvider> converterProviders = new ArrayList<ParamConverterProvider>();

    @Inject
    ParamConverterFactory(ServiceLocator locator) {
        Set customProviders = Providers.getCustomProviders((ServiceLocator)locator, ParamConverterProvider.class);
        this.converterProviders.addAll(customProviders);
        Set providers = Providers.getProviders((ServiceLocator)locator, ParamConverterProvider.class);
        providers.removeAll(customProviders);
        this.converterProviders.addAll(providers);
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        for (ParamConverterProvider provider : this.converterProviders) {
            ParamConverter converter = provider.getConverter(rawType, genericType, annotations);
            if (converter == null) continue;
            return converter;
        }
        return null;
    }
}

