/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class StoreConfig {
    private Duration ttl = new Duration(1.0, TimeUnit.HOURS);

    @Deprecated
    @LegacyConfig(value={"store.ttl-in-ms"}, replacedBy="store.ttl")
    public StoreConfig setTtlInMs(int duration) {
        return this.setTtl(new Duration((double)duration, TimeUnit.MILLISECONDS));
    }

    @Config(value="store.ttl")
    public StoreConfig setTtl(Duration ttl) {
        Preconditions.checkNotNull((Object)ttl, (Object)"ttl must not be null");
        Preconditions.checkArgument((ttl.toMillis() > 0L ? 1 : 0) != 0, (Object)"ttl must be > 0");
        this.ttl = ttl;
        return this;
    }

    @NotNull
    public Duration getTtl() {
        return this.ttl;
    }
}

