/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CompletableCallback;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse response = exchange.getResponse();
        MetaData.Response metaData = (MetaData.Response)frame.getMetaData();
        response.version(metaData.getVersion()).status(metaData.getStatus()).reason(metaData.getReason());
        if (this.responseBegin(exchange)) {
            HttpFields headers = metaData.getFields();
            for (HttpField header : headers) {
                if (this.responseHeader(exchange, header)) continue;
                return;
            }
            if (this.responseHeaders(exchange) && frame.isEndStream()) {
                this.responseSuccess(exchange);
            }
        }
    }

    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    public void onData(Stream stream, final DataFrame frame, final Callback callback) {
        final HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed((Throwable)new IOException("terminated"));
            return;
        }
        final ByteBufferPool byteBufferPool = this.getHttpDestination().getHttpClient().getByteBufferPool();
        ByteBuffer original = frame.getData();
        int length = original.remaining();
        final ByteBuffer copy = byteBufferPool.acquire(length, original.isDirect());
        BufferUtil.clearToFill((ByteBuffer)copy);
        copy.put(original);
        BufferUtil.flipToFlush((ByteBuffer)copy, (int)0);
        CompletableCallback delegate = new CompletableCallback(){

            public void succeeded() {
                byteBufferPool.release(copy);
                callback.succeeded();
                super.succeeded();
            }

            public void failed(Throwable x) {
                byteBufferPool.release(copy);
                callback.failed(x);
                super.failed(x);
            }

            public void resume() {
                if (frame.isEndStream()) {
                    HttpReceiverOverHTTP2.this.responseSuccess(exchange);
                }
            }

            public void abort(Throwable failure) {
            }
        };
        this.responseContent(exchange, copy, (Callback)delegate);
        if (!delegate.tryComplete()) {
            delegate.resume();
        }
    }

    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        ErrorCode error = ErrorCode.from((int)frame.getError());
        String reason = error == null ? "reset" : error.name().toLowerCase(Locale.ENGLISH);
        exchange.getRequest().abort((Throwable)new IOException(reason));
    }

    public void onTimeout(Stream stream, Throwable failure) {
        this.responseFailure(failure);
    }
}

