/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310ArraySerializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.temporal.ChronoField;

public class OffsetTimeSerializer
extends JSR310ArraySerializerBase<OffsetTime> {
    public static final OffsetTimeSerializer INSTANCE = new OffsetTimeSerializer();

    protected OffsetTimeSerializer() {
        super(OffsetTime.class);
    }

    public void serialize(OffsetTime time, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            generator.writeStartArray();
            generator.writeNumber(time.getHour());
            generator.writeNumber(time.getMinute());
            if (time.getSecond() > 0 || time.getNano() > 0) {
                generator.writeNumber(time.getSecond());
                if (time.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        generator.writeNumber(time.getNano());
                    } else {
                        generator.writeNumber(time.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            generator.writeString(time.getOffset().toString());
            generator.writeEndArray();
        } else {
            generator.writeString(time.toString());
        }
    }
}

