/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Signature {
    private final String actionName;
    private final List<String> parameterTypes;

    public Signature(Method method) {
        this.actionName = method.getName();
        ArrayList<String> builder = new ArrayList<String>();
        for (Class<?> type : method.getParameterTypes()) {
            builder.add(type.getName());
        }
        this.parameterTypes = Collections.unmodifiableList(builder);
    }

    public Signature(String actionName, String ... parameterTypes) {
        this(actionName, Arrays.asList(parameterTypes));
    }

    public Signature(String actionName, List<String> parameterTypes) {
        this.actionName = actionName;
        this.parameterTypes = Collections.unmodifiableList(parameterTypes);
    }

    public Signature(MBeanOperationInfo info) {
        this.actionName = info.getName();
        ArrayList<String> parameterTypes = new ArrayList<String>(info.getSignature().length);
        for (MBeanParameterInfo parameterInfo : info.getSignature()) {
            parameterTypes.add(parameterInfo.getType());
        }
        this.parameterTypes = Collections.unmodifiableList(parameterTypes);
    }

    public String getActionName() {
        return this.actionName;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature1 = (Signature)o;
        if (!this.actionName.equals(signature1.actionName)) {
            return false;
        }
        return this.parameterTypes.equals(signature1.parameterTypes);
    }

    public int hashCode() {
        int result = this.actionName.hashCode();
        result = 31 * result + this.parameterTypes.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.actionName).append('(');
        boolean first = true;
        for (String type : this.parameterTypes) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(type);
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }
}

