/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import io.airlift.stats.QuantileDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class Distribution {
    private static final double MAX_ERROR = 0.01;
    @GuardedBy(value="this")
    private final QuantileDigest digest;

    public Distribution() {
        this.digest = new QuantileDigest(0.01);
    }

    public Distribution(double alpha) {
        this.digest = new QuantileDigest(0.01, alpha);
    }

    public synchronized void add(long value) {
        this.digest.add(value);
    }

    @Managed
    public synchronized double getMaxError() {
        return this.digest.getConfidenceFactor();
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized long getP50() {
        return this.digest.getQuantile(0.5);
    }

    @Managed
    public synchronized long getP75() {
        return this.digest.getQuantile(0.75);
    }

    @Managed
    public synchronized long getP90() {
        return this.digest.getQuantile(0.9);
    }

    @Managed
    public synchronized long getP95() {
        return this.digest.getQuantile(0.95);
    }

    @Managed
    public synchronized long getP99() {
        return this.digest.getQuantile(0.99);
    }

    @Managed
    public synchronized long getMin() {
        return this.digest.getMin();
    }

    @Managed
    public synchronized long getMax() {
        return this.digest.getMax();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Long> getPercentiles() {
        List<Long> values;
        ArrayList<Double> percentiles = new ArrayList<Double>(100);
        for (int i = 0; i < 100; ++i) {
            percentiles.add((double)i / 100.0);
        }
        Distribution distribution = this;
        synchronized (distribution) {
            values = this.digest.getQuantiles(percentiles);
        }
        LinkedHashMap<Double, Long> result = new LinkedHashMap<Double, Long>(values.size());
        for (int i = 0; i < percentiles.size(); ++i) {
            result.put((Double)percentiles.get(i), values.get(i));
        }
        return result;
    }

    public DistributionSnapshot snapshot() {
        return new DistributionSnapshot(this.getMaxError(), this.getCount(), this.getP50(), this.getP75(), this.getP90(), this.getP95(), this.getP99(), this.getMin(), this.getMax());
    }

    public static class DistributionSnapshot {
        private final double maxError;
        private final double count;
        private final long p50;
        private final long p75;
        private final long p90;
        private final long p95;
        private final long p99;
        private final long min;
        private final long max;

        @JsonCreator
        public DistributionSnapshot(@JsonProperty(value="maxError") double maxError, @JsonProperty(value="count") double count, @JsonProperty(value="p50") long p50, @JsonProperty(value="p75") long p75, @JsonProperty(value="p90") long p90, @JsonProperty(value="p95") long p95, @JsonProperty(value="p99") long p99, @JsonProperty(value="min") long min, @JsonProperty(value="max") long max) {
            this.maxError = maxError;
            this.count = count;
            this.p50 = p50;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p99 = p99;
            this.min = min;
            this.max = max;
        }

        @JsonProperty
        public double getMaxError() {
            return this.maxError;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public long getP50() {
            return this.p50;
        }

        @JsonProperty
        public long getP75() {
            return this.p75;
        }

        @JsonProperty
        public long getP90() {
            return this.p90;
        }

        @JsonProperty
        public long getP95() {
            return this.p95;
        }

        @JsonProperty
        public long getP99() {
            return this.p99;
        }

        @JsonProperty
        public long getMin() {
            return this.min;
        }

        @JsonProperty
        public long getMax() {
            return this.max;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("maxError", this.maxError).add("count", this.count).add("p50", this.p50).add("p75", this.p75).add("p90", this.p90).add("p95", this.p95).add("p99", this.p99).add("min", this.min).add("max", this.max).toString();
        }
    }
}

