/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

class UnsafeUtil {
    private static final Unsafe unsafe;
    private static final int ALIGNMENT = 8;
    private static final int BASE_SIZE;

    UnsafeUtil() {
    }

    public static int sizeOf(Class<?> clazz) {
        long maxOffset = -1L;
        Field lastField = null;
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                long offset;
                if (Modifier.isStatic(field.getModifiers()) || (offset = unsafe.objectFieldOffset(field)) <= maxOffset) continue;
                lastField = field;
                maxOffset = offset;
            }
            clazz = clazz.getSuperclass();
        }
        if (lastField != null) {
            Class<?> fieldType = lastField.getType();
            Class arrayType = fieldType == Boolean.TYPE ? boolean[].class : (fieldType == Byte.TYPE ? byte[].class : (fieldType == Short.TYPE ? short[].class : (fieldType == Integer.TYPE ? int[].class : (fieldType == Long.TYPE ? long[].class : (fieldType == Float.TYPE ? float[].class : (fieldType == Double.TYPE ? double[].class : Object[].class))))));
            return UnsafeUtil.align((int)(maxOffset + (long)unsafe.arrayIndexScale(arrayType)), 8);
        }
        return BASE_SIZE;
    }

    private static int align(int size, int alignment) {
        return (size / alignment + 1) * alignment;
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
            BASE_SIZE = UnsafeUtil.align((int)unsafe.objectFieldOffset(Dummy.class.getDeclaredField("dummy")), 8);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class Dummy {
        byte dummy;

        private Dummy() {
        }
    }
}

