/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.spi.container.WebApplication;
import io.airlift.log.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;

@Provider
@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
class JsonMapper
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
    private static final ImmutableSet<Class<?>> IO_CLASSES = ImmutableSet.builder().add(InputStream.class).add(Reader.class).add(OutputStream.class).add(Writer.class).add(byte[].class).add(char[].class).add(StreamingOutput.class).add(Response.class).build();
    public static final Logger log = Logger.get(JsonMapper.class);
    private final ObjectMapper objectMapper;
    private final WebApplication webApplication;

    @Inject
    public JsonMapper(ObjectMapper objectMapper, WebApplication webApplication) {
        this.objectMapper = objectMapper;
        this.webApplication = webApplication;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.canReadOrWrite(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.canReadOrWrite(type);
    }

    private boolean canReadOrWrite(Class<?> type) {
        if (IO_CLASSES.contains(type)) {
            return false;
        }
        for (Class ioClass : IO_CLASSES) {
            if (!ioClass.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        Object object;
        try {
            JsonParser jsonParser = this.objectMapper.getFactory().createJsonParser(inputStream);
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            object = this.objectMapper.readValue(jsonParser, this.objectMapper.getTypeFactory().constructType(genericType));
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw (IOException)e;
            }
            log.debug((Throwable)e, "Invalid json for Java type %s", new Object[]{type});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid json for Java type " + type)).build());
        }
        Set violations = VALIDATOR.validate(object, new Class[0]);
        if (!violations.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(JsonMapper.messagesFor(violations)).build());
        }
        return object;
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        httpHeaders.add((Object)"X-Content-Type-Options", (Object)"nosniff");
        JsonFactory jsonFactory = this.objectMapper.getJsonFactory();
        jsonFactory.setCharacterEscapes((CharacterEscapes)HTMLCharacterEscapes.INSTANCE);
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(outputStream, JsonEncoding.UTF8);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (this.isPrettyPrintRequested()) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = this.objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        ObjectWriter writer = rootType != null ? this.objectMapper.writerWithType(rootType) : this.objectMapper.writer();
        String jsonpFunctionName = this.getJsonpFunctionName();
        if (jsonpFunctionName != null) {
            value = new JSONPObject(jsonpFunctionName, value, rootType);
        }
        writer.writeValue(jsonGenerator, value);
        outputStream.write(10);
    }

    private boolean isPrettyPrintRequested() {
        if (this.webApplication == null) {
            return false;
        }
        HttpContext httpContext = this.webApplication.getThreadLocalHttpContext();
        if (httpContext == null) {
            return false;
        }
        ExtendedUriInfo uriInfo = httpContext.getUriInfo();
        if (uriInfo == null) {
            return false;
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        return queryParameters != null && queryParameters.containsKey((Object)"pretty");
    }

    private String getJsonpFunctionName() {
        if (this.webApplication == null) {
            return null;
        }
        HttpContext httpContext = this.webApplication.getThreadLocalHttpContext();
        if (httpContext == null) {
            return null;
        }
        ExtendedUriInfo uriInfo = httpContext.getUriInfo();
        if (uriInfo == null) {
            return null;
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        if (queryParameters == null) {
            return null;
        }
        return (String)queryParameters.getFirst((Object)"jsonp");
    }

    private static List<String> messagesFor(Collection<? extends ConstraintViolation<?>> violations) {
        ImmutableList.Builder messages = new ImmutableList.Builder();
        for (ConstraintViolation<?> violation : violations) {
            messages.add((Object)(violation.getPropertyPath().toString() + " " + violation.getMessage()));
        }
        return messages.build();
    }

    private static class HTMLCharacterEscapes
    extends CharacterEscapes {
        private static final HTMLCharacterEscapes INSTANCE = new HTMLCharacterEscapes();
        private final int[] asciiEscapes;

        private HTMLCharacterEscapes() {
            int[] esc = CharacterEscapes.standardAsciiEscapesForJSON();
            esc[60] = -1;
            esc[62] = -1;
            esc[38] = -1;
            esc[39] = -1;
            this.asciiEscapes = esc;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

