/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ClassPathResourceHandler
extends AbstractHandler {
    private static final MimeTypes MIME_TYPES = new MimeTypes();
    private final String baseUri;
    private final String classPathResourceBase;
    private final List<String> welcomeFiles;

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, String ... welcomeFiles) {
        this(baseUri, classPathResourceBase, (List<String>)ImmutableList.copyOf((Object[])welcomeFiles));
    }

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, List<String> welcomeFiles) {
        Preconditions.checkNotNull((Object)baseUri, (Object)"baseUri is null");
        Preconditions.checkNotNull((Object)classPathResourceBase, (Object)"classPathResourceBase is null");
        Preconditions.checkNotNull(welcomeFiles, (Object)"welcomeFiles is null");
        baseUri = baseUri.startsWith("/") ? baseUri : '/' + baseUri;
        this.baseUri = baseUri = baseUri.endsWith("/") ? baseUri.substring(baseUri.length() - 1) : baseUri;
        this.classPathResourceBase = classPathResourceBase;
        ImmutableList.Builder files = ImmutableList.builder();
        for (String welcomeFile : welcomeFiles) {
            if (!welcomeFile.startsWith("/")) {
                welcomeFile = "/" + welcomeFile;
            }
            files.add((Object)welcomeFile);
        }
        this.welcomeFiles = files.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        URL resource = this.getResourcePath(request);
        if (resource == null) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        boolean skipContent = false;
        if (!"GET".equals(method)) {
            if ("HEAD".equals(method)) {
                skipContent = true;
            } else {
                response.sendError(405);
                return;
            }
        }
        InputStream resourceStream = null;
        try {
            ServletOutputStream out;
            resourceStream = resource.openStream();
            Buffer contentTypeBytes = MIME_TYPES.getMimeByExtension(resource.toString());
            if (contentTypeBytes != null) {
                String contentTypeHeaderValue = contentTypeBytes.toString(Charsets.US_ASCII);
                response.setContentType(contentTypeHeaderValue);
            }
            if (skipContent) {
                return;
            }
            try {
                out = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                out = new WriterOutputStream((Writer)response.getWriter());
            }
            if (out instanceof AbstractHttpConnection.Output) {
                ((AbstractHttpConnection.Output)out).sendContent((Object)resourceStream);
            } else {
                ByteStreams.copy((InputStream)resourceStream, (OutputStream)out);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)resourceStream);
        }
    }

    private URL getResourcePath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || !pathInfo.startsWith(this.baseUri)) {
            return null;
        }
        if (!this.baseUri.equals("/")) {
            pathInfo = pathInfo.substring(this.baseUri.length());
        }
        if (!pathInfo.startsWith("/") && !pathInfo.isEmpty()) {
            return null;
        }
        if (!pathInfo.startsWith("/")) {
            pathInfo = "/";
        }
        if (!"/".equals(pathInfo)) {
            String resourcePath = this.classPathResourceBase + pathInfo;
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
            return resource;
        }
        for (String welcomeFile : this.welcomeFiles) {
            String resourcePath = this.classPathResourceBase + welcomeFile;
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    static {
        MIME_TYPES.addMimeMapping("json", "application/json");
    }
}

