/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.ClassPathResourceHandler;
import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.GZipRequestFilter;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.StatsRecordingHandler;
import io.airlift.http.server.TimingFilter;
import io.airlift.http.server.TraceTokenFilter;
import io.airlift.node.NodeInfo;
import io.airlift.tracetoken.TraceTokenManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpServer {
    private final Server server;
    private final Connector httpConnector;
    private final Connector httpsConnector;
    private final Connector adminConnector;

    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Servlet theAdminServlet, Map<String, String> adminParameters, Set<Filter> adminFilters, MBeanServer mbeanServer, LoginService loginService, TraceTokenManager tokenManager, RequestStats stats, EventClient eventClient) throws IOException {
        Preconditions.checkNotNull((Object)httpServerInfo, (Object)"httpServerInfo is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)theServlet, (Object)"theServlet is null");
        Server server = new Server();
        server.setSendServerVersion(false);
        if (mbeanServer != null) {
            MBeanContainer mbeanContainer = new MBeanContainer(mbeanServer){

                public void doStart() {
                }
            };
            server.getContainer().addEventListener((Container.Listener)mbeanContainer);
        }
        SelectChannelConnector httpConnector = null;
        if (config.isHttpEnabled()) {
            httpConnector = new SelectChannelConnector();
            httpConnector.setName("http");
            httpConnector.setPort(httpServerInfo.getHttpUri().getPort());
            httpConnector.setMaxIdleTime((int)config.getNetworkMaxIdleTime().convertTo(TimeUnit.MILLISECONDS));
            httpConnector.setStatsOn(true);
            httpConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            if (config.getMaxRequestHeaderSize() != null) {
                httpConnector.setRequestHeaderSize(Ints.checkedCast((long)config.getMaxRequestHeaderSize().toBytes()));
            }
            server.addConnector((Connector)httpConnector);
        }
        SslSelectChannelConnector httpsConnector = null;
        if (config.isHttpsEnabled()) {
            httpsConnector = new SslSelectChannelConnector();
            httpsConnector.setName("https");
            httpsConnector.setPort(httpServerInfo.getHttpsUri().getPort());
            httpsConnector.setStatsOn(true);
            httpsConnector.setKeystore(config.getKeystorePath());
            httpsConnector.setPassword(config.getKeystorePassword());
            httpsConnector.setMaxIdleTime((int)config.getNetworkMaxIdleTime().convertTo(TimeUnit.MILLISECONDS));
            httpsConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            if (config.getMaxRequestHeaderSize() != null) {
                httpsConnector.setRequestHeaderSize(Ints.checkedCast((long)config.getMaxRequestHeaderSize().toBytes()));
            }
            httpsConnector.setAllowRenegotiate(true);
            server.addConnector((Connector)httpsConnector);
        }
        SelectChannelConnector adminConnector = null;
        if (theAdminServlet != null && config.isAdminEnabled()) {
            if (config.isHttpsEnabled()) {
                SslSelectChannelConnector connector = new SslSelectChannelConnector();
                connector.setKeystore(config.getKeystorePath());
                connector.setPassword(config.getKeystorePassword());
                connector.setAllowRenegotiate(true);
                adminConnector = connector;
            } else {
                adminConnector = new SelectChannelConnector();
            }
            adminConnector.setName("admin");
            adminConnector.setPort(httpServerInfo.getAdminUri().getPort());
            adminConnector.setMaxIdleTime((int)config.getNetworkMaxIdleTime().convertTo(TimeUnit.MILLISECONDS));
            adminConnector.setStatsOn(true);
            adminConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            if (config.getMaxRequestHeaderSize() != null) {
                adminConnector.setRequestHeaderSize(Ints.checkedCast((long)config.getMaxRequestHeaderSize().toBytes()));
            }
            QueuedThreadPool adminThreadPool = new QueuedThreadPool(config.getAdminMaxThreads());
            adminThreadPool.setName("http-admin-worker");
            adminThreadPool.setMinThreads(config.getAdminMinThreads());
            adminThreadPool.setMaxIdleTimeMs((int)config.getThreadMaxIdleTime().convertTo(TimeUnit.MILLISECONDS));
            adminConnector.setThreadPool((ThreadPool)adminThreadPool);
            server.addBean((Object)adminThreadPool);
            server.addConnector((Connector)adminConnector);
        }
        QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads());
        threadPool.setMinThreads(config.getMinThreads());
        threadPool.setMaxIdleTimeMs((int)config.getThreadMaxIdleTime().convertTo(TimeUnit.MILLISECONDS));
        threadPool.setName("http-worker");
        server.setThreadPool((ThreadPool)threadPool);
        HandlerCollection handlers = new HandlerCollection();
        for (HttpServerBinder.HttpResourceBinding resource : resources) {
            handlers.addHandler((Handler)new ClassPathResourceHandler(resource.getBaseUri(), resource.getClassPathResourceBase(), resource.getWelcomeFiles()));
        }
        handlers.addHandler((Handler)HttpServer.createServletContext(theServlet, parameters, filters, tokenManager, loginService, "http", "https"));
        RequestLogHandler logHandler = this.createLogHandler(config, tokenManager, eventClient);
        if (logHandler != null) {
            handlers.addHandler((Handler)logHandler);
        }
        RequestLogHandler statsRecorder = new RequestLogHandler();
        statsRecorder.setRequestLog((RequestLog)new StatsRecordingHandler(stats));
        handlers.addHandler((Handler)statsRecorder);
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        HandlerList rootHandlers = new HandlerList();
        if (theAdminServlet != null && config.isAdminEnabled()) {
            rootHandlers.addHandler((Handler)HttpServer.createServletContext(theAdminServlet, adminParameters, adminFilters, tokenManager, loginService, "admin"));
        }
        rootHandlers.addHandler((Handler)statsHandler);
        server.setHandler((Handler)rootHandlers);
        this.server = server;
        this.httpConnector = httpConnector;
        this.httpsConnector = httpsConnector;
        this.adminConnector = adminConnector;
    }

    private static ServletContextHandler createServletContext(Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, TraceTokenManager tokenManager, LoginService loginService, String ... connectorNames) {
        ServletContextHandler context = new ServletContextHandler(0);
        context.addFilter(new FilterHolder((Filter)new TimingFilter()), "/*", null);
        if (tokenManager != null) {
            context.addFilter(new FilterHolder((Filter)new TraceTokenFilter(tokenManager)), "/*", null);
        }
        context.addFilter(GzipFilter.class, "/*", null);
        context.addFilter(GZipRequestFilter.class, "/*", null);
        if (loginService != null) {
            SecurityHandler securityHandler = HttpServer.createSecurityHandler(loginService);
            context.setSecurityHandler(securityHandler);
        }
        for (Filter filter : filters) {
            context.addFilter(new FilterHolder(filter), "/*", null);
        }
        ServletHolder servletHolder = new ServletHolder(theServlet);
        servletHolder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
        context.addServlet(servletHolder, "/*");
        context.setConnectorNames(connectorNames);
        return context;
    }

    private static SecurityHandler createSecurityHandler(LoginService loginService) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(false);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setConstraintMappings(Arrays.asList(constraintMapping));
        return securityHandler;
    }

    protected RequestLogHandler createLogHandler(HttpServerConfig config, TraceTokenManager tokenManager, EventClient eventClient) throws IOException {
        RequestLogHandler logHandler = new RequestLogHandler();
        File logFile = new File(config.getLogPath());
        if (logFile.exists() && !logFile.isFile()) {
            throw new IOException(String.format("Log path %s exists but is not a file", logFile.getAbsolutePath()));
        }
        File logPath = logFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            throw new IOException(String.format("Cannot create %s and path does not already exist", logPath.getAbsolutePath()));
        }
        DelimitedRequestLog requestLog = new DelimitedRequestLog(config.getLogPath(), (int)config.getLogRetentionTime().convertTo(TimeUnit.DAYS), tokenManager, eventClient);
        logHandler.setRequestLog((RequestLog)requestLog);
        return logHandler;
    }

    @PostConstruct
    public void start() throws Exception {
        this.server.start();
        Preconditions.checkState((boolean)this.server.isRunning(), (Object)"server is not running");
        HttpServer.checkSufficientThreads(this.httpConnector, "HTTP");
        HttpServer.checkSufficientThreads(this.httpsConnector, "HTTPS");
        HttpServer.checkSufficientThreads(this.adminConnector, "admin");
    }

    @PreDestroy
    public void stop() throws Exception {
        this.server.stop();
    }

    private static void checkSufficientThreads(Connector connector, String name) {
        Preconditions.checkState((connector == null || !connector.isLowResources() ? 1 : 0) != 0, (String)"insufficient threads configured for %s connector", (Object[])new Object[]{name});
    }
}

