/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.http.server.RequestStats;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

public class StatsRecordingHandler
implements RequestLog {
    private final RequestStats stats;

    public StatsRecordingHandler(RequestStats stats) {
        this.stats = stats;
    }

    public void log(Request request, Response response) {
        Duration requestTime = new Duration((double)Math.max(0L, System.currentTimeMillis() - request.getTimeStamp()), TimeUnit.MILLISECONDS);
        long dispatchTime = request.getDispatchTime();
        if (dispatchTime == 0L) {
            dispatchTime = request.getTimeStamp();
        }
        Duration schedulingDelay = new Duration((double)Math.max(0L, dispatchTime - request.getTimeStamp()), TimeUnit.MILLISECONDS);
        this.stats.record(request.getMethod(), response.getStatus(), request.getContentRead(), response.getContentCount(), schedulingDelay, requestTime);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isRunning() {
        return true;
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }

    public boolean isFailed() {
        return false;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }
}

