/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import java.net.InetAddress;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class NodeConfig {
    public static final String ENV_REGEXP = "[a-z0-9][_a-z0-9]*";
    public static final String POOL_REGEXP = "[a-z0-9][_a-z0-9]*";
    private String environment;
    private String pool = "general";
    private String nodeId;
    private String location;
    private InetAddress nodeInternalIp;
    private String nodeExternalAddress;
    private InetAddress nodeBindIp;
    private String binarySpec;
    private String configSpec;

    @NotNull
    @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed")
    public String getEnvironment() {
        return this.environment;
    }

    @Config(value="node.environment")
    public NodeConfig setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    @NotNull
    @Pattern(regexp="[a-z0-9][_a-z0-9]*", message="is malformed")
    public String getPool() {
        return this.pool;
    }

    @Config(value="node.pool")
    public NodeConfig setPool(String pool) {
        this.pool = pool;
        return this;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Config(value="node.id")
    public NodeConfig setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    @Config(value="node.location")
    public NodeConfig setLocation(String location) {
        this.location = location;
        return this;
    }

    public InetAddress getNodeInternalIp() {
        return this.nodeInternalIp;
    }

    public NodeConfig setNodeInternalIp(InetAddress nodeInternalIp) {
        this.nodeInternalIp = nodeInternalIp;
        return this;
    }

    @Config(value="node.ip")
    @LegacyConfig(value={"http-server.ip", "jetty.ip"})
    public NodeConfig setNodeInternalIp(String nodeInternalIp) {
        if (nodeInternalIp != null) {
            this.nodeInternalIp = InetAddresses.forString((String)nodeInternalIp);
        }
        return this;
    }

    public String getNodeExternalAddress() {
        return this.nodeExternalAddress;
    }

    @Config(value="node.external-address")
    public NodeConfig setNodeExternalAddress(String nodeExternalAddress) {
        this.nodeExternalAddress = nodeExternalAddress;
        return this;
    }

    public InetAddress getNodeBindIp() {
        return this.nodeBindIp;
    }

    public NodeConfig setNodeBindIp(InetAddress nodeBindIp) {
        this.nodeBindIp = nodeBindIp;
        return this;
    }

    @Config(value="node.bind-ip")
    public NodeConfig setNodeBindIp(String nodeBindIp) {
        if (nodeBindIp != null) {
            this.nodeBindIp = InetAddresses.forString((String)nodeBindIp);
        }
        return this;
    }

    public String getBinarySpec() {
        return this.binarySpec;
    }

    @Config(value="node.binary-spec")
    public NodeConfig setBinarySpec(String binarySpec) {
        this.binarySpec = binarySpec;
        return this;
    }

    public String getConfigSpec() {
        return this.configSpec;
    }

    @Config(value="node.config-spec")
    public NodeConfig setConfigSpec(String configSpec) {
        this.configSpec = configSpec;
        return this;
    }
}

