/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.HttpServiceSelectorProvider;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorProvider;
import io.airlift.discovery.client.ServiceType;
import io.airlift.discovery.client.ServiceTypes;
import java.lang.annotation.Annotation;

public class DiscoveryBinder {
    private final Multibinder<ServiceAnnouncement> serviceAnnouncementBinder;
    private final Binder binder;

    public static DiscoveryBinder discoveryBinder(Binder binder) {
        Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
        return new DiscoveryBinder(binder);
    }

    protected DiscoveryBinder(Binder binder) {
        Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
        this.binder = binder;
        this.serviceAnnouncementBinder = Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
    }

    public void bindSelector(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.bindSelector(ServiceTypes.serviceType(type));
    }

    public void bindSelector(ServiceType serviceType) {
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith((Annotation)serviceType).prefixedWith("discovery." + serviceType.value()).to(ServiceSelectorConfig.class);
        this.binder.bind(ServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new ServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public void bindServiceAnnouncement(ServiceAnnouncement announcement) {
        Preconditions.checkNotNull((Object)announcement, (Object)"announcement is null");
        this.serviceAnnouncementBinder.addBinding().toInstance((Object)announcement);
    }

    public void bindServiceAnnouncement(Provider<ServiceAnnouncement> announcementProvider) {
        Preconditions.checkNotNull(announcementProvider, (Object)"announcementProvider is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProvider);
    }

    public <T extends ServiceAnnouncement> void bindServiceAnnouncement(Class<? extends Provider<T>> announcementProviderClass) {
        Preconditions.checkNotNull(announcementProviderClass, (Object)"announcementProviderClass is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProviderClass);
    }

    public ServiceAnnouncement.ServiceAnnouncementBuilder bindHttpAnnouncement(String type) {
        ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder = ServiceAnnouncement.serviceAnnouncement(type);
        this.bindServiceAnnouncement(new HttpAnnouncementProvider(serviceAnnouncementBuilder));
        return serviceAnnouncementBuilder;
    }

    public void bindHttpSelector(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.bindHttpSelector(ServiceTypes.serviceType(type));
    }

    public void bindHttpSelector(ServiceType serviceType) {
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        this.bindSelector(serviceType);
        this.binder.bind(HttpServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    static class HttpAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final ServiceAnnouncement.ServiceAnnouncementBuilder builder;
        private AnnouncementHttpServerInfo httpServerInfo;

        public HttpAnnouncementProvider(ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder) {
            this.builder = serviceAnnouncementBuilder;
        }

        @Inject
        public void setAnnouncementHttpServerInfo(AnnouncementHttpServerInfo httpServerInfo) {
            this.httpServerInfo = httpServerInfo;
        }

        public ServiceAnnouncement get() {
            if (this.httpServerInfo.getHttpUri() != null) {
                this.builder.addProperty("http", this.httpServerInfo.getHttpUri().toString());
                this.builder.addProperty("http-external", this.httpServerInfo.getHttpExternalUri().toString());
            }
            if (this.httpServerInfo.getHttpsUri() != null) {
                this.builder.addProperty("https", this.httpServerInfo.getHttpsUri().toString());
                this.builder.addProperty("https-external", this.httpServerInfo.getHttpsExternalUri().toString());
            }
            return this.builder.build();
        }
    }
}

