/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

public class FullJsonResponseHandler<T>
implements ResponseHandler<JsonResponse<T>, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final JsonCodec<T> jsonCodec;

    public static <T> FullJsonResponseHandler<T> createFullJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new FullJsonResponseHandler<T>(jsonCodec);
    }

    private FullJsonResponseHandler(JsonCodec<T> jsonCodec) {
        this.jsonCodec = jsonCodec;
    }

    @Override
    public RuntimeException handleException(Request request, Exception exception) {
        if (exception instanceof ConnectException) {
            return new RuntimeException("Server refused connection: " + request.getUri().toASCIIString());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }

    @Override
    public JsonResponse<T> handle(Request request, Response response) {
        String contentType = response.getHeader("Content-Type");
        if (contentType == null || !MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            return new JsonResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
        }
        try {
            String json = CharStreams.toString((Readable)new InputStreamReader(response.getInputStream(), Charsets.UTF_8));
            return new JsonResponse<T>(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), this.jsonCodec, json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading JSON response from server", e);
        }
    }

    @NotThreadSafe
    public static class JsonResponse<T> {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<String, String> headers;
        private final boolean hasValue;
        private final String json;
        private final T value;
        private final IllegalArgumentException exception;

        public JsonResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.hasValue = false;
            this.json = null;
            this.value = null;
            this.exception = null;
        }

        public JsonResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers, JsonCodec<T> jsonCodec, String json) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.json = json;
            Object value = null;
            IllegalArgumentException exception = null;
            try {
                value = jsonCodec.fromJson(json);
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            this.hasValue = exception == null;
            this.value = value;
            this.exception = exception;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)name);
            if (values.isEmpty()) {
                return null;
            }
            return (String)values.get(0);
        }

        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public T getValue() {
            if (!this.hasValue) {
                throw new IllegalStateException("Response does not contain a JSON value", this.exception);
            }
            return this.value;
        }

        public String getJson() {
            return this.json;
        }

        public IllegalArgumentException getException() {
            return this.exception;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", this.headers).add("hasValue", this.hasValue).add("value", this.value).toString();
        }
    }
}

