/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.http.client.AbstractHttpClientModule;
import io.airlift.http.client.ApacheHttpClient;
import io.airlift.http.client.CompositeQualifier;
import io.airlift.http.client.CompositeQualifierImpl;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.weakref.jmx.guice.ExportBinder;

@Beta
class HttpClientModule
extends AbstractHttpClientModule {
    HttpClientModule(String name, Class<? extends Annotation> annotation) {
        super(name, annotation);
    }

    @Override
    public Annotation getFilterQualifier() {
        return HttpClientModule.filterQualifier(this.annotation);
    }

    @Override
    public void configure() {
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith(this.annotation).prefixedWith(this.name).to(HttpClientConfig.class);
        this.binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.annotation)).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder, HttpRequestFilter.class, (Annotation)HttpClientModule.filterQualifier(this.annotation));
        ExportBinder.newExporter((Binder)this.binder).export(HttpClient.class).annotatedWith(this.annotation).withGeneratedName();
    }

    @Override
    public void addAlias(Class<? extends Annotation> alias) {
        this.binder.bind(HttpClient.class).annotatedWith(alias).to(Key.get(HttpClient.class, (Class)this.annotation));
    }

    private static Key<Set<HttpRequestFilter>> filterKey(Class<? extends Annotation> annotation) {
        return Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, (Annotation)HttpClientModule.filterQualifier(annotation));
    }

    private static CompositeQualifier filterQualifier(Class<? extends Annotation> annotation) {
        return CompositeQualifierImpl.compositeQualifier(annotation, HttpClient.class);
    }

    private static class HttpClientProvider
    implements Provider<HttpClient> {
        private final List<ApacheHttpClient> clients = new ArrayList<ApacheHttpClient>();
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private HttpClientProvider(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        @PreDestroy
        public void destroy() {
            for (ApacheHttpClient client : this.clients) {
                client.close();
            }
        }

        public HttpClient get() {
            HttpClientConfig config = (HttpClientConfig)this.injector.getInstance(Key.get(HttpClientConfig.class, this.annotation));
            Set filters = (Set)this.injector.getInstance(HttpClientModule.filterKey(this.annotation));
            ApacheHttpClient client = new ApacheHttpClient(config, filters);
            this.clients.add(client);
            return client;
        }
    }
}

