/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import io.airlift.http.client.BodyGenerator;
import io.airlift.json.JsonCodec;
import java.io.OutputStream;

@Beta
public class JsonBodyGenerator<T>
implements BodyGenerator {
    private final byte[] json;

    public static <T> JsonBodyGenerator<T> jsonBodyGenerator(JsonCodec<T> jsonCodec, T instance) {
        return new JsonBodyGenerator<T>(jsonCodec, instance);
    }

    private JsonBodyGenerator(JsonCodec<T> jsonCodec, T instance) {
        this.json = jsonCodec.toJson(instance).getBytes(Charsets.UTF_8);
    }

    @Override
    public void write(OutputStream out) throws Exception {
        out.write(this.json);
    }
}

