/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CountingOutputStream;
import io.airlift.http.client.Request;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.CloneUtils;

public abstract class StatsHttpUriRequest
extends HttpRequestBase {
    public static StatsHttpUriRequest createGenericHttpRequest(Request request) {
        if (request.getBodyGenerator() == null) {
            return new GenericHttpRequest(request);
        }
        return new GenericEntityHttpRequest(request);
    }

    public long getBytesWritten() {
        return 0L;
    }

    private static class GenericEntityHttpRequest
    extends GenericHttpRequest
    implements HttpEntityEnclosingRequest {
        private HttpEntity entity;
        private CountingOutputStream countingOutputStream;

        public GenericEntityHttpRequest(final Request request) {
            super(request);
            Preconditions.checkArgument((request.getBodyGenerator() != null ? 1 : 0) != 0, (Object)"Generic entity request must have a body");
            this.entity = new HttpEntity(){

                public boolean isRepeatable() {
                    return true;
                }

                public boolean isChunked() {
                    return true;
                }

                public long getContentLength() {
                    return -1L;
                }

                public Header getContentType() {
                    return null;
                }

                public Header getContentEncoding() {
                    return null;
                }

                public InputStream getContent() throws IOException, IllegalStateException {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.writeTo(out);
                    return new ByteArrayInputStream(out.toByteArray());
                }

                public void writeTo(OutputStream out) throws IOException {
                    try {
                        GenericEntityHttpRequest.this.countingOutputStream = new CountingOutputStream(out);
                        request.getBodyGenerator().write((OutputStream)GenericEntityHttpRequest.this.countingOutputStream);
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e, IOException.class);
                        throw new IOException(e);
                    }
                }

                public boolean isStreaming() {
                    return true;
                }

                public void consumeContent() {
                }
            };
        }

        public HttpEntity getEntity() {
            return this.entity;
        }

        public void setEntity(HttpEntity entity) {
            throw new UnsupportedOperationException();
        }

        public boolean expectContinue() {
            Header expect = this.getFirstHeader("Expect");
            return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        }

        @Override
        public long getBytesWritten() {
            if (this.countingOutputStream == null) {
                return 0L;
            }
            return this.countingOutputStream.getCount();
        }

        public Object clone() throws CloneNotSupportedException {
            GenericEntityHttpRequest clone = (GenericEntityHttpRequest)((Object)super.clone());
            if (this.entity != null) {
                clone.entity = (HttpEntity)CloneUtils.clone((Object)this.entity);
            }
            return clone;
        }
    }

    private static class GenericHttpRequest
    extends StatsHttpUriRequest {
        private final String method;

        GenericHttpRequest(Request request) {
            this.method = request.getMethod();
            this.setURI(request.getUri());
            for (Map.Entry entry : request.getHeaders().entries()) {
                this.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public String getMethod() {
            return this.method;
        }
    }
}

