/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.http.client.netty.NettyConnectionPool;
import io.airlift.http.client.netty.NettyHttpResponseChannelHandler;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.Timer;

public class HttpClientPipelineFactory
implements ChannelPipelineFactory {
    private final Timer timer;
    private final OrderedMemoryAwareThreadPoolExecutor executor;
    private final ReadTimeoutHandler timeoutHandler;
    private final NettyConnectionPool nettyConnectionPool;
    private final int maxContentLength;

    public HttpClientPipelineFactory(NettyConnectionPool nettyConnectionPool, Timer timer, OrderedMemoryAwareThreadPoolExecutor executor, Duration readTimeout, DataSize maxContentLength) {
        this.timer = timer;
        Preconditions.checkNotNull((Object)nettyConnectionPool, (Object)"nettyConnectionPool is null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkNotNull((Object)readTimeout, (Object)"readTimeout is null");
        Preconditions.checkNotNull((Object)maxContentLength, (Object)"maxContentLength is null");
        this.nettyConnectionPool = nettyConnectionPool;
        this.executor = executor;
        this.timeoutHandler = new ReadTimeoutHandler(this.timer, (long)readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        this.maxContentLength = Ints.checkedCast((long)maxContentLength.toBytes());
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("timeout", (ChannelHandler)this.timeoutHandler);
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.maxContentLength));
        pipeline.addLast("pipelineExecutor", (ChannelHandler)new ExecutionHandler((Executor)this.executor));
        pipeline.addLast("handler", (ChannelHandler)new NettyHttpResponseChannelHandler(this.nettyConnectionPool));
        return pipeline;
    }
}

