/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.netty.CanceledRequestException;
import io.airlift.http.client.netty.HttpClientPipelineFactory;
import io.airlift.http.client.netty.NettyAsyncHttpClientConfig;
import io.airlift.http.client.netty.NettyConnectionPool;
import io.airlift.http.client.netty.NettyHttpResponseChannelHandler;
import io.airlift.http.client.netty.NettyIoPool;
import io.airlift.http.client.netty.NettyResponseFuture;
import io.airlift.http.client.netty.UnknownRequestException;
import io.airlift.http.client.netty.socks.Socks4ClientBootstrap;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@Beta
public class NettyAsyncHttpClient
implements AsyncHttpClient {
    private final RequestStats stats = new RequestStats();
    private final List<HttpRequestFilter> requestFilters;
    private final OrderedMemoryAwareThreadPoolExecutor executor;
    private final NettyConnectionPool nettyConnectionPool;
    private final HashedWheelTimer timer;

    public NettyAsyncHttpClient(String name, HttpClientConfig config, NettyIoPool ioPool) {
        this(name, ioPool, config, new NettyAsyncHttpClientConfig(), Collections.emptySet());
    }

    public NettyAsyncHttpClient(String name, NettyIoPool ioPool, HttpClientConfig config, NettyAsyncHttpClientConfig asyncConfig, Set<? extends HttpRequestFilter> requestFilters) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)ioPool, (Object)"ioPool is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)asyncConfig, (Object)"asyncConfig is null");
        Preconditions.checkNotNull(requestFilters, (Object)"requestFilters is null");
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        String namePrefix = "http-client-" + name;
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat(namePrefix + "-timer-%s").setDaemon(true).build());
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((BossPool)ioPool.getBossPool(), (WorkerPool)ioPool.getWorkerPool());
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setNameFormat(namePrefix + "-worker-%s").setDaemon(true).build();
        this.executor = new OrderedMemoryAwareThreadPoolExecutor(asyncConfig.getWorkerThreads(), 0L, 0L, 30L, TimeUnit.SECONDS, workerThreadFactory);
        Object bootstrap = config.getSocksProxy() == null ? new ClientBootstrap((ChannelFactory)channelFactory) : new Socks4ClientBootstrap((ChannelFactory)channelFactory, config.getSocksProxy());
        bootstrap.setOption("connectTimeoutMillis", (Object)((long)config.getConnectTimeout().toMillis()));
        bootstrap.setOption("soLinger", (Object)0);
        this.nettyConnectionPool = new NettyConnectionPool((ClientBootstrap)bootstrap, config.getMaxConnections(), (Executor)this.executor, asyncConfig.isEnableConnectionPooling());
        HttpClientPipelineFactory pipelineFactory = new HttpClientPipelineFactory(this.nettyConnectionPool, (Timer)this.timer, this.executor, config.getReadTimeout(), asyncConfig.getMaxContentLength());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)pipelineFactory);
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            // empty catch block
        }
        Closeables.closeQuietly((Closeable)this.nettyConnectionPool);
        try {
            this.timer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        return ((NettyResponseFuture)this.executeAsync(request, (ResponseHandler)responseHandler)).checkedGet();
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    public <T, E extends Exception> NettyResponseFuture<T, E> executeAsync(Request request, ResponseHandler<T, E> responseHandler) throws E {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        Preconditions.checkArgument(("http".equalsIgnoreCase(request.getUri().getScheme()) || "https".equalsIgnoreCase(request.getUri().getScheme()) ? 1 : 0) != 0, (String)"%s only supports http and https requests", (Object[])new Object[]{this.getClass().getSimpleName()});
        NettyResponseFuture<T, E> nettyResponseFuture = new NettyResponseFuture<T, E>(request, responseHandler, this.stats);
        this.nettyConnectionPool.execute(request.getUri(), new HttpConnectionCallback<T, E>(request, nettyResponseFuture));
        return nettyResponseFuture;
    }

    @VisibleForTesting
    public static HttpRequest buildNettyHttpRequest(Request request) throws Exception {
        URI uri = request.getUri();
        StringBuilder pathBuilder = new StringBuilder(100);
        if (uri.getRawPath() == null || uri.getRawPath().isEmpty()) {
            pathBuilder.append('/');
        } else {
            pathBuilder.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            pathBuilder.append('?').append(uri.getRawQuery());
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, new HttpMethod(request.getMethod()), pathBuilder.toString());
        if (uri.getPort() == -1) {
            nettyRequest.setHeader("Host", (Object)uri.getHost());
        } else {
            nettyRequest.setHeader("Host", (Object)(uri.getHost() + ":" + uri.getPort()));
        }
        for (Map.Entry header : request.getHeaders().asMap().entrySet()) {
            nettyRequest.setHeader((String)header.getKey(), (Iterable)header.getValue());
        }
        BodyGenerator bodyGenerator = request.getBodyGenerator();
        if (bodyGenerator != null) {
            DynamicChannelBuffer content = new DynamicChannelBuffer(65536);
            ChannelBufferOutputStream out = new ChannelBufferOutputStream((ChannelBuffer)content);
            bodyGenerator.write((OutputStream)out);
            nettyRequest.setHeader("Content-Length", (Object)content.readableBytes());
            nettyRequest.setContent((ChannelBuffer)content);
        }
        return nettyRequest;
    }

    private static class HttpConnectionCallback<T, E extends Exception>
    implements NettyConnectionPool.ConnectionCallback {
        private final Request request;
        private final NettyResponseFuture<T, E> nettyResponseFuture;

        public HttpConnectionCallback(Request request, NettyResponseFuture<T, E> nettyResponseFuture) {
            this.request = request;
            this.nettyResponseFuture = nettyResponseFuture;
        }

        @Override
        public void run(Channel channel) throws Exception {
            this.nettyResponseFuture.setState(NettyResponseFuture.NettyAsyncHttpState.SENDING_REQUEST);
            channel.getPipeline().getContext(NettyHttpResponseChannelHandler.class).setAttachment(this.nettyResponseFuture);
            HttpRequest nettyRequest = NettyAsyncHttpClient.buildNettyHttpRequest(this.request);
            channel.write((Object)nettyRequest).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        HttpConnectionCallback.this.nettyResponseFuture.setState(NettyResponseFuture.NettyAsyncHttpState.WAITING_FOR_RESPONSE);
                    } else if (future.isCancelled()) {
                        HttpConnectionCallback.this.nettyResponseFuture.setException(new CanceledRequestException());
                    } else {
                        Throwable cause = future.getCause();
                        if (cause == null) {
                            cause = new UnknownRequestException();
                        }
                        HttpConnectionCallback.this.nettyResponseFuture.setException(cause);
                    }
                }
            });
        }

        @Override
        public void onError(Throwable throwable) {
            this.nettyResponseFuture.setException(throwable);
        }
    }
}

