/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class NettyResponse
implements Response {
    private final int statusCode;
    private final String statusMessage;
    private final ListMultimap<String, String> headers;
    private final byte[] content;

    public NettyResponse(HttpResponse httpResponse) {
        HttpResponseStatus status = httpResponse.getStatus();
        this.statusCode = status.getCode();
        this.statusMessage = status.getReasonPhrase();
        ImmutableListMultimap.Builder headers = ImmutableListMultimap.builder();
        for (Map.Entry header : httpResponse.getHeaders()) {
            headers.put(header);
        }
        this.headers = headers.build();
        ChannelBuffer content = httpResponse.getContent();
        byte[] bytes = new byte[content.readableBytes()];
        content.getBytes(content.readerIndex(), bytes);
        this.content = bytes;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public String getHeader(String name) {
        List values = this.headers.get((Object)name);
        if (values != null && !values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    @Override
    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.content.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }
}

