/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import io.airlift.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

class LoggingWriter
extends StringWriter {
    private final Logger logger;
    private final Type type;

    public LoggingWriter(Logger logger, Type type) {
        this.logger = logger;
        this.type = type;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        BufferedReader in = new BufferedReader(new StringReader(this.getBuffer().toString()));
        try {
            String line;
            block5: while ((line = in.readLine()) != null) {
                switch (this.type) {
                    default: {
                        if (!this.logger.isDebugEnabled()) continue block5;
                        this.logger.debug(line);
                        continue block5;
                    }
                    case INFO: 
                }
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info(line);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.getBuffer().setLength(0);
    }

    public void printMessage(String message, Object ... args) {
        this.write(String.format(message, args) + "\n");
    }

    public static enum Type {
        DEBUG,
        INFO;

    }
}

