/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

class GZipRequestWrapper
extends HttpServletRequestWrapper {
    private final HttpServletRequest request;

    public GZipRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamFromInputStream(new GZIPInputStream((InputStream)this.request.getInputStream()));
    }

    public int getContentLength() {
        return -1;
    }

    public String getHeader(String name) {
        if (StringUtils.equalsIgnoreCase((String)name, (String)"content-length")) {
            return null;
        }
        return this.request.getHeader(name);
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    private static class ServletInputStreamFromInputStream
    extends ServletInputStream {
        private final InputStream stream;

        public ServletInputStreamFromInputStream(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        public void reset() throws IOException {
            this.stream.reset();
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

