/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.BodyGenerator;
import java.net.URI;
import java.util.List;
import java.util.Map;

@Beta
public class Request {
    private final URI uri;
    private final String method;
    private final ListMultimap<String, String> headers;
    private final BodyGenerator bodyGenerator;

    public Request(URI uri, String method, ListMultimap<String, String> headers, BodyGenerator bodyGenerator) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkNotNull((Object)uri.getHost(), (String)"uri does not have a host: %s", (Object[])new Object[]{uri});
        Preconditions.checkNotNull((Object)method, (Object)"method is null");
        Preconditions.checkNotNull((Object)uri.getScheme(), (String)"uri does not have a scheme: %s", (Object[])new Object[]{uri});
        String scheme = uri.getScheme().toLowerCase();
        Preconditions.checkArgument((!"http".equals(scheme) || !"https".equals(scheme) ? 1 : 0) != 0, (String)"uri scheme must be http or https: %s", (Object[])new Object[]{uri});
        this.uri = Request.validateUri(uri);
        this.method = method;
        this.headers = ImmutableListMultimap.copyOf(headers);
        this.bodyGenerator = bodyGenerator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeader(String name) {
        List values = this.headers.get((Object)name);
        if (values != null && !values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    public BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("method", (Object)this.method).add("headers", this.headers).add("bodyGenerator", (Object)this.bodyGenerator).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request r = (Request)o;
        return Objects.equal((Object)this.uri, (Object)r.uri) && Objects.equal((Object)this.method, (Object)r.method) && Objects.equal(this.headers, r.headers) && Objects.equal((Object)this.bodyGenerator, (Object)r.bodyGenerator);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uri, this.method, this.headers, this.bodyGenerator});
    }

    private static URI validateUri(URI uri) {
        Preconditions.checkArgument((uri.getPort() != 0 ? 1 : 0) != 0, (Object)"Cannot make requests to HTTP port 0");
        return uri;
    }

    @Beta
    public static class Builder {
        private URI uri;
        private String method;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private BodyGenerator bodyGenerator;

        public static Builder prepareHead() {
            return new Builder().setMethod("HEAD");
        }

        public static Builder prepareGet() {
            return new Builder().setMethod("GET");
        }

        public static Builder preparePost() {
            return new Builder().setMethod("POST");
        }

        public static Builder preparePut() {
            return new Builder().setMethod("PUT");
        }

        public static Builder prepareDelete() {
            return new Builder().setMethod("DELETE");
        }

        public static Builder fromRequest(Request request) {
            Builder requestBuilder = new Builder();
            requestBuilder.setMethod(request.getMethod());
            requestBuilder.setBodyGenerator(request.getBodyGenerator());
            requestBuilder.setUri(request.getUri());
            for (Map.Entry entry : request.getHeaders().entries()) {
                requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            return requestBuilder;
        }

        public Builder setUri(URI uri) {
            this.uri = Request.validateUri(uri);
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headers.removeAll((Object)name);
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder setBodyGenerator(BodyGenerator bodyGenerator) {
            this.bodyGenerator = bodyGenerator;
            return this;
        }

        public Request build() {
            return new Request(this.uri, this.method, this.headers, this.bodyGenerator);
        }
    }
}

