/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import java.util.List;

@Beta
public class UnexpectedResponseException
extends RuntimeException {
    private final Request request;
    private final int statusCode;
    private final String statusMessage;
    private final ListMultimap<String, String> headers;

    public UnexpectedResponseException(Request request, Response response) {
        this(String.format("%d: %s", response.getStatusCode(), response.getStatusMessage()), request, response.getStatusCode(), response.getStatusMessage(), (ListMultimap<String, String>)ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, Response response) {
        this(message, request, response.getStatusCode(), response.getStatusMessage(), (ListMultimap<String, String>)ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, int statusCode, String statusMessage, ListMultimap<String, String> headers) {
        super(message);
        this.request = request;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = ImmutableListMultimap.copyOf(headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getHeader(String name) {
        List values = this.getHeaders().get((Object)name);
        if (values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("request", (Object)this.request).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", this.headers).toString();
    }
}

