/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import io.airlift.http.client.netty.NettyConnectionPool;
import io.airlift.http.client.netty.NettyResponseFuture;
import io.airlift.http.client.netty.UnknownRequestException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.timeout.ReadTimeoutException;

public class NettyHttpResponseChannelHandler
extends SimpleChannelUpstreamHandler {
    private final NettyConnectionPool nettyConnectionPool;

    public NettyHttpResponseChannelHandler(NettyConnectionPool nettyConnectionPool) {
        this.nettyConnectionPool = nettyConnectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext context, MessageEvent event) throws Exception {
        HttpResponse response;
        Channel channel = context.getChannel();
        NettyResponseFuture nettyResponseFuture = (NettyResponseFuture)context.getAttachment();
        try {
            response = (HttpResponse)event.getMessage();
            if (nettyResponseFuture != null) {
                nettyResponseFuture.completed(response);
            }
        }
        catch (Exception e) {
            this.handleException(context, e);
            return;
        }
        finally {
            context.setAttachment(null);
        }
        String connectionHeader = response.getHeader("Connection");
        if (connectionHeader != null && connectionHeader.equalsIgnoreCase("close")) {
            this.nettyConnectionPool.destroyConnection(channel);
        } else {
            this.nettyConnectionPool.returnConnection(channel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, ExceptionEvent event) throws Exception {
        this.handleException(context, event.getCause());
    }

    public void channelDisconnected(ChannelHandlerContext context, ChannelStateEvent event) throws Exception {
        this.handleException(context, new ClosedChannelException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(ChannelHandlerContext context, Throwable cause) {
        try {
            NettyResponseFuture nettyResponseFuture = (NettyResponseFuture)context.getAttachment();
            if (nettyResponseFuture != null) {
                if (cause instanceof ReadTimeoutException) {
                    SocketTimeoutException socketTimeoutException = new SocketTimeoutException("Read timeout");
                    socketTimeoutException.initCause(cause);
                    cause = socketTimeoutException;
                }
                if (cause == null) {
                    cause = new UnknownRequestException();
                }
                nettyResponseFuture.failed(cause);
            }
        }
        finally {
            context.setAttachment(null);
            this.nettyConnectionPool.destroyConnection(context.getChannel());
        }
    }
}

