/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.netty.NettyIoPoolConfig;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

@Beta
public class NettyIoPool
implements Closeable {
    private final HashedWheelTimer hashedWheelTimer;
    private final ExecutorService bossExecutor;
    private final ExecutorService workerExecutor;
    private final NioWorkerPool workerPool;
    private final NioClientBossPool bossPool;
    private final String name;

    public NettyIoPool(String name) {
        this(name, new NettyIoPoolConfig());
    }

    public NettyIoPool(String name, NettyIoPoolConfig config) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        String prefix = "netty-client-" + name + "-io-";
        String nameFormat = prefix + "timer-%s";
        this.hashedWheelTimer = new HashedWheelTimer(Threads.daemonThreadsNamed((String)nameFormat));
        this.bossExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(prefix + "boss-%s")));
        this.workerExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(prefix + "worker-%s")));
        this.bossPool = new NioClientBossPool((Executor)this.bossExecutor, config.getIoBossThreads(), (Timer)this.hashedWheelTimer, ThreadNameDeterminer.CURRENT);
        this.workerPool = new NioWorkerPool((Executor)this.workerExecutor, config.getIoWorkerThreads(), ThreadNameDeterminer.CURRENT);
    }

    public NioClientBossPool getBossPool() {
        return this.bossPool;
    }

    public NioWorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.bossPool.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.workerPool.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.hashedWheelTimer.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.bossExecutor.shutdownNow();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.workerExecutor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "Netty IO Pool for " + this.name;
    }
}

