/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.netty.NettyResponse;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.handler.codec.http.HttpResponse;

class NettyResponseFuture<T, E extends Exception>
extends AbstractFuture<T>
implements AsyncHttpClient.AsyncHttpResponseFuture<T> {
    private static final Logger log = Logger.get(NettyResponseFuture.class);
    private final long requestStart = System.nanoTime();
    private final AtomicReference<NettyAsyncHttpState> state = new AtomicReference<NettyAsyncHttpState>(NettyAsyncHttpState.WAITING_FOR_CONNECTION);
    private final Request request;
    private final ResponseHandler<T, E> responseHandler;
    private final RequestStats stats;

    public NettyResponseFuture(Request request, ResponseHandler<T, E> responseHandler, RequestStats stats) {
        this.request = request;
        this.responseHandler = responseHandler;
        this.stats = stats;
    }

    @Override
    public String getState() {
        return this.state.get().toString();
    }

    protected void setState(NettyAsyncHttpState state) {
        this.state.set(state);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.state.set(NettyAsyncHttpState.CANCELED);
        return super.cancel(mayInterruptIfRunning);
    }

    protected void completed(HttpResponse httpResponse) {
        T value;
        if (this.state.get() == NettyAsyncHttpState.CANCELED) {
            return;
        }
        try {
            value = this.processResponse(httpResponse);
        }
        catch (Throwable e) {
            this.storeException(e);
            return;
        }
        this.state.set(NettyAsyncHttpState.DONE);
        this.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T processResponse(HttpResponse httpResponse) throws E {
        T value;
        long responseStart = System.nanoTime();
        this.state.set(NettyAsyncHttpState.PROCESSING_RESPONSE);
        NettyResponse response = null;
        try {
            response = new NettyResponse(httpResponse);
            value = this.responseHandler.handle(this.request, response);
        }
        finally {
            Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
            Duration requestProcessingTime = new Duration((double)(responseStart - this.requestStart), TimeUnit.NANOSECONDS);
            if (response != null) {
                this.stats.record(this.request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
            }
        }
        return value;
    }

    protected void failed(Throwable throwable) {
        if (this.state.get() == NettyAsyncHttpState.CANCELED) {
            return;
        }
        if (throwable instanceof Exception) {
            try {
                T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                this.state.set(NettyAsyncHttpState.DONE);
                this.set(value);
                return;
            }
            catch (Throwable newThrowable) {
                throwable = newThrowable;
            }
        }
        this.storeException(throwable);
    }

    private void storeException(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.state.set(NettyAsyncHttpState.CANCELED);
        } else {
            this.state.set(NettyAsyncHttpState.FAILED);
        }
        if (throwable == null) {
            throwable = new Throwable("Throwable is null");
            log.error(throwable, "Something is broken");
        }
        this.setException(throwable);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
    }

    public static enum NettyAsyncHttpState {
        WAITING_FOR_CONNECTION,
        SENDING_REQUEST,
        WAITING_FOR_RESPONSE,
        PROCESSING_RESPONSE,
        DONE,
        FAILED,
        CANCELED;

    }
}

