/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

public class PermitQueue {
    private final int maxPermits;
    @GuardedBy(value="this")
    private final Queue<SettableFuture<?>> pending = new LinkedList();
    @GuardedBy(value="this")
    private int permits;

    public PermitQueue(int maxPermits) {
        this.maxPermits = maxPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> acquire() {
        SettableFuture future = SettableFuture.create();
        boolean acquired = false;
        PermitQueue permitQueue = this;
        synchronized (permitQueue) {
            if (this.permits < this.maxPermits) {
                ++this.permits;
                acquired = true;
            } else {
                this.pending.add(future);
            }
        }
        if (acquired) {
            future.set(null);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SettableFuture<?> future = null;
        boolean acquired = false;
        PermitQueue permitQueue = this;
        synchronized (permitQueue) {
            Preconditions.checkState((this.permits >= 0 ? 1 : 0) != 0, (Object)"Used permits is already 0");
            --this.permits;
            if (this.permits < this.maxPermits && (future = this.pending.poll()) != null) {
                ++this.permits;
                acquired = true;
            }
        }
        if (acquired) {
            future.set(null);
        }
    }
}

