/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty;

import com.google.common.io.Closeables;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.netty.NettyAsyncHttpClient;
import io.airlift.http.client.netty.NettyAsyncHttpClientConfig;
import io.airlift.http.client.netty.NettyIoPool;
import io.airlift.http.client.netty.NettyIoPoolConfig;
import java.io.Closeable;
import java.util.Collections;
import java.util.Set;

public class StandaloneNettyAsyncHttpClient
implements AsyncHttpClient {
    private final NettyIoPool ioPool;
    private final NettyAsyncHttpClient httpClient;

    public StandaloneNettyAsyncHttpClient(String name) {
        this(name, new HttpClientConfig());
    }

    public StandaloneNettyAsyncHttpClient(String name, HttpClientConfig httpClientConfig) {
        this(name, httpClientConfig, new NettyAsyncHttpClientConfig(), new NettyIoPoolConfig(), Collections.emptySet());
    }

    public StandaloneNettyAsyncHttpClient(String name, HttpClientConfig httpClientConfig, NettyAsyncHttpClientConfig asyncHttpClientConfig, NettyIoPoolConfig ioPoolConfig, Set<? extends HttpRequestFilter> filters) {
        this.ioPool = new NettyIoPool(name, ioPoolConfig);
        this.httpClient = new NettyAsyncHttpClient(name, this.ioPool, httpClientConfig, asyncHttpClientConfig, filters);
    }

    @Override
    public void close() {
        Closeables.closeQuietly((Closeable)this.httpClient);
        Closeables.closeQuietly((Closeable)this.ioPool);
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        return this.httpClient.execute(request, responseHandler);
    }

    @Override
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @Override
    public <T, E extends Exception> AsyncHttpClient.AsyncHttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        return this.httpClient.executeAsync(request, responseHandler);
    }
}

