/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty.socks;

import com.google.common.net.HostAndPort;
import io.airlift.http.client.netty.socks.SettableChannelFuture;
import io.airlift.http.client.netty.socks.Socks4HandshakeHandler;
import io.airlift.http.client.netty.socks.SocksProtocols;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FixedLengthFrameDecoder;

public class Socks4ClientBootstrap
extends ClientBootstrap {
    static final String FRAME_DECODER = "frameDecoder";
    static final String HANDSHAKE = "handshake";
    private final HostAndPort socksProxyAddr;

    public Socks4ClientBootstrap(ChannelFactory channelFactory, HostAndPort socksProxyAddr) {
        super(channelFactory);
        this.socksProxyAddr = socksProxyAddr;
    }

    public ChannelPipelineFactory getPipelineFactory() {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                cp.addLast(Socks4ClientBootstrap.FRAME_DECODER, (ChannelHandler)new FixedLengthFrameDecoder(8));
                cp.addLast(Socks4ClientBootstrap.HANDSHAKE, (ChannelHandler)new Socks4HandshakeHandler(Socks4ClientBootstrap.super.getPipelineFactory()));
                return cp;
            }
        };
    }

    public ChannelFuture connect(final SocketAddress remoteAddress) {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("expecting InetSocketAddress");
        }
        final SettableChannelFuture settableChannelFuture = new SettableChannelFuture();
        super.connect((SocketAddress)new InetSocketAddress(this.socksProxyAddr.getHostText(), this.socksProxyAddr.getPort())).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                settableChannelFuture.setChannel(future.getChannel());
                if (future.isSuccess()) {
                    Socks4ClientBootstrap.this.socksConnect(future.getChannel(), (InetSocketAddress)remoteAddress).addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture innerFuture) throws Exception {
                            if (innerFuture.isSuccess()) {
                                settableChannelFuture.setSuccess();
                            } else {
                                settableChannelFuture.setFailure(innerFuture.getCause());
                            }
                        }
                    });
                } else {
                    settableChannelFuture.setFailure(future.getCause());
                }
            }
        });
        return settableChannelFuture;
    }

    private ChannelFuture socksConnect(Channel channel, InetSocketAddress remoteAddress) {
        ChannelBuffer handshake = null;
        if (remoteAddress.getAddress() == null && remoteAddress.getHostName() != null || remoteAddress.getHostName().equals("localhost")) {
            handshake = SocksProtocols.createSock4aPacket(remoteAddress.getHostName(), remoteAddress.getPort());
        }
        if (remoteAddress.getAddress() != null) {
            handshake = SocksProtocols.createSocks4packet(remoteAddress.getAddress(), remoteAddress.getPort());
        }
        if (handshake == null) {
            throw new IllegalArgumentException("Invalid Address " + remoteAddress);
        }
        channel.write((Object)handshake);
        return ((Socks4HandshakeHandler)channel.getPipeline().get(HANDSHAKE)).getChannelFuture();
    }
}

