/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.netty.socks;

import io.airlift.http.client.netty.socks.SettableChannelFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class Socks4HandshakeHandler
extends SimpleChannelHandler {
    private final SettableChannelFuture channelFuture = new SettableChannelFuture();
    private final ChannelPipelineFactory delegate;

    public Socks4HandshakeHandler(ChannelPipelineFactory delegate) {
        this.delegate = delegate;
    }

    public SettableChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.channelFuture.setChannel(ctx.getChannel());
        if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer msg = (ChannelBuffer)e.getMessage();
            if (msg.readableBytes() < 8) {
                this.channelFuture.setFailure(new IOException("invalid sock server reply length = " + msg.readableBytes()));
            }
            msg.readByte();
            byte status = msg.readByte();
            short port = msg.readShort();
            byte[] addr = new byte[4];
            msg.readBytes(addr);
            ctx.getChannel().setAttachment((Object)new InetSocketAddress(InetAddress.getByAddress(addr), (int)port));
            if (status == 90) {
                ctx.getPipeline().remove("frameDecoder");
                ctx.getPipeline().remove("handshake");
                ChannelPipeline delegatePipeline = this.delegate.getPipeline();
                for (String name : delegatePipeline.getNames()) {
                    ctx.getPipeline().addLast(name, delegatePipeline.get(name));
                }
                this.channelFuture.setSuccess();
            } else {
                this.channelFuture.setFailure(new IOException("sock server reply failure code :" + Integer.toHexString(status)));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.channelFuture.setChannel(ctx.getChannel());
        this.channelFuture.setFailure(e.getCause());
    }
}

