/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import io.airlift.sample.Person;

@EventType(value="Person")
public class PersonEvent {
    private final Operation operation;
    private final String personId;
    private final Person person;

    public static PersonEvent personAdded(String personId, Person person) {
        return new PersonEvent(Operation.ADDED, personId, person);
    }

    public static PersonEvent personUpdated(String personId, Person person) {
        return new PersonEvent(Operation.UPDATED, personId, person);
    }

    public static PersonEvent personRemoved(String personId, Person person) {
        return new PersonEvent(Operation.REMOVED, personId, person);
    }

    private PersonEvent(Operation operation, String personId, Person person) {
        Preconditions.checkNotNull((Object)((Object)operation), (Object)"operation is null");
        Preconditions.checkNotNull((Object)personId, (Object)"id is null");
        Preconditions.checkNotNull((Object)person, (Object)"person is null");
        this.operation = operation;
        this.personId = personId;
        this.person = person;
    }

    @EventField
    public String getOperation() {
        return this.operation.toString();
    }

    @EventField
    public String getPersonId() {
        return this.personId;
    }

    @EventField
    public String getEmail() {
        return this.person.getEmail();
    }

    @EventField
    public String getName() {
        return this.person.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonEvent that = (PersonEvent)o;
        if (this.operation != that.operation) {
            return false;
        }
        if (!this.person.equals(that.person)) {
            return false;
        }
        return this.personId.equals(that.personId);
    }

    public int hashCode() {
        int result = this.operation.hashCode();
        result = 31 * result + this.personId.hashCode();
        result = 31 * result + this.person.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("personId", (Object)this.personId).add("person", (Object)this.person).toString();
    }

    public static enum Operation {
        ADDED,
        UPDATED,
        REMOVED;

    }
}

